<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\sidebar\SidebarController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class InfoInstitucionalController extends Controller
{
    /* ---------- MUESTRA LA VISTA---------- */
    public function index(Request $request)
    {
        return view('admin.institucion.info_institucional.index');
    }


    /* ---------- DEVUELVE JSON ---------- */
    public function list()
    {
        $info = DB::table('info_institucional')->find(1);
        if (! $info) {
            DB::table('info_institucional')->insert([
                'id' => 1,
                'nombre' => 'Mi Institución',
                'logo' => null,
                'direccion' => 'Dirección inicial',
                'contacto' => 'Contacto inicial',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            $info = DB::table('info_institucional')->find(1);
        }
        
        $info->logo_url = $info->logo
            ? route('admin.institucion.logo', ['file' => $info->logo])
            : null;
        
        return response()->json($info);
    }


    /* ---------- ACTUALIZA ---------- */
    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'nombre' => 'required|string|max:255',
            'direccion' => 'required|string|max:255',
            'contacto' => 'required|string|max:255',
            'logoFile' => 'nullable|image|mimes:jpg,jpeg,png',
        ]);
        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }
        
        $currentLogo = DB::table('info_institucional')->where('id', 1)->value('logo');
        $logoPath = $currentLogo;
        
        if ($request->hasFile('logoFile')) {
            $file = $request->file('logoFile');
            $extension = $file->getClientOriginalExtension();
            $filename = 'logo.'.$extension;
            $logoPath = 'imagenes/institucion/'.$filename;
            
            if ($currentLogo && $currentLogo != $logoPath) {
                Storage::delete('public/'.$currentLogo);
            }
            $file->storeAs('public/imagenes/institucion', $filename);
        }
        
        DB::table('info_institucional')->where('id', 1)->update([
            'nombre' => $request->nombre,
            'logo' => $logoPath,
            'direccion' => $request->direccion,
            'contacto' => $request->contacto,
            'updated_at' => now(),
        ]);
        
        return response()->json([
            'message' => 'Información actualizada correctamente',
            'logo_url' => $logoPath ? route('admin.institucion.logo', ['file' => $logoPath]) : null,
        ]);
    }


    public function verLogo($file)
    {
        // sanitiza
        $file = str_replace(['../', '..\\'], '', $file);
        $file = ltrim($file, '/');
        
        $path = storage_path('app/public/'.$file);
        
        if (! file_exists($path)) {
            abort(404, 'Logo no encontrado.');
        }
        
        $ext = strtolower(pathinfo($path, PATHINFO_EXTENSION));
        $map = [
            'png' => 'image/png',
            'jpg' => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'gif' => 'image/gif',
            'svg' => 'image/svg+xml',
            'webp' => 'image/webp',
        ];
        $mime = $map[$ext] ?? 'application/octet-stream';
        
        return response()->file($path, ['Content-Type' => $mime]);
    }


    public function cargarLogo()
    {
        // Buscar la publicación por ID
        $item = DB::table('info_institucional')->find(1);
        
        if (!$item || !$item->logo) {
            abort(404, 'Imagen no encontrada.');
        }
        
        // Ruta completa del archivo de la imagen
        $file = storage_path('app/public/'). $item->logo;
        
        if (file_exists($file)) {
            // Determinar el tipo MIME de la imagen
            $mimeType = mime_content_type($file);
            
            if (strpos($mimeType, 'image/') !== 0) {
                abort(400, 'El archivo no es una imagen válida.');
            }
            
            // Devolver la imagen como respuesta
            return response()->file($file, ['Content-Type' => $mimeType,]);
        } else {
            abort(404, 'Archivo no encontrado.');
        }
    }
}
