<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Indicator;
use Illuminate\Http\Request;
use App\Models\Course;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class IndicatorController extends Controller
{

    public function index(Request $request)
    {
        return view('admin.notas.indicadores.index');
    }


    public function list(Request $request)
    {
        $idsubject = $request->input('idsubject');
        $idsemester = $request->input('idsemester');
        // $docentedata = Auth::User()->teachers;
        // $idteacher = $docentedata[0]->id;

        if ($request->ajax()) {
            $data = DB::table('asignaturas as s')
            ->select(
                DB::raw('COALESCE(s.id, 0) as idsubject'),
                DB::raw('COALESCE(i.id, 0) as idindicator'),
                DB::raw('COALESCE(i.nombre, "") as indicador'),
                DB::raw('COALESCE(i.descripcion, "") as indicador_descripcion'),
                DB::raw('COALESCE(a.id, 0) as idactivity'),
                DB::raw('COALESCE(a.nombre, "") as actividad'),
                DB::raw('COALESCE(a.fecha, "") as fecha'),
                DB::raw('COALESCE(g.id, 0) as idgrade'),
                DB::raw('COALESCE(g.nombre, "") as nota'),
                DB::raw('COALESCE(g.porcentaje, 0) as porcentaje')
            )
            ->join('indicadores as i', 'i.subject_id', '=', 's.id')
            ->leftJoin('actividades as a', 'a.indicator_id', '=', 'i.id')
            ->leftJoin('notas as g', 'g.activity_id', '=', 'a.id')
            ->where('s.id', '=', $idsubject)
            ->where('s.semester_id', '=', $idsemester)
            ->orderBy('indicador')
            ->orderBy('actividad')
            ->orderBy('nota')
            ->get();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function store(Request $request)
    {
        $item = new Indicator();
        $item->nombre = $request->input('txt-i_nombre');
        $item->descripcion = $request->input('txt-i_descripcion');
        // $item->fecha = $request->input('txt-fecha');
        $item->subject_id = $request->input('txt-idsubject');

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            // El guardado fue exitoso
            return response()->json([
                "status" => true,
                "mensaje" => 'Indicator guardado'
            ]);
        } else {
            // El guardado falló
            return response()->json([
                "status" => false,
                "mensaje" => 'Indicator no guardado'
            ]);
        }
    }


    public function update(Request $request, $id)
    {

        $item = Indicator::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->nombre = $request->input('txt-i_nombre');
            $item->descripcion = $request->input('txt-i_descripcion');

            if ($item->save()) {
                // El guardado fue exitoso
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                // El guardado falló
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {
        // Busca el registro por su ID
        $item = Indicator::find($id);

        // Verifica si el registro existe
        if (!$item) {
            return response()->json([
                "status" => false,
                "mensaje" => 'El registro no existe'
            ]);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'El registro fue eliminado'
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'No se puede eliminar porque ya cuenta con registros asociados'
            ]);
        }
    }

}
