<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Grade;
use App\Models\Studentgrade;
use Illuminate\Http\Request;

class GradeController extends Controller
{
    //
    public function store(Request $request)
    {
        $item = new Grade();
        $item->nombre = $request->input('txt-g_nombre');
        $item->porcentaje = $request->input('txt-g_porcentaje');
        $item->activity_id = $request->input('txt-g_idactivity');
        $item->tipo_nota = $request->has('chk-g_tipo_nota') ? 1 : 0;
        $item->fecha_limite = $request->input('txt-g_fecha_limite');

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            // El guardado fue exitoso
            return response()->json([
                'status' => true,
                'mensaje' => 'Grade guardado',
            ]);
        } else {
            // El guardado falló
            return response()->json([
                'status' => false,
                'mensaje' => 'Grade no guardado',
            ]);
        }
    }

    public function update(Request $request, $id)
    {
        $item = Grade::find($id);

        if (! $item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {

            $item->nombre = $request->input('txt-g_nombre');
            $item->porcentaje = $request->input('txt-g_porcentaje');
            $item->tipo_nota = $request->has('chk-g_tipo_nota') ? 1 : 0;
            $item->fecha_limite = $request->input('txt-g_fecha_limite');

            if ($item->save()) {
                // El guardado fue exitoso
                return response()->json(['status' => true, 'mensaje' => 'Registro actualizado']);
            } else {
                // El guardado falló
                return response()->json(['status' => false, 'mensaje' => 'Registro no actualizado']);
            }
        }
    }

    public function destroy($id)
    {
        // Busca el registro por su ID
        $item = Grade::find($id);

        $notas_estudiantes = Studentgrade::where('grade_id', $id);
        $notas_estudiantes->delete();

        // Verifica si el registro existe
        if (! $item) {
            return response()->json([
                'status' => false,
                'mensaje' => 'El registro no existe',
            ]);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json([
                'status' => true,
                'mensaje' => 'El registro fue eliminado',
            ]);
        } else {
            return response()->json([
                'status' => false,
                'mensaje' => 'No se puede eliminar porque ya cuenta con registros asociados',
            ]);
        }
    }
}
