<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;

class EvaluacionCurricularController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('admin.planes_estudio.evaluacion.index');
    }

    public function grafica_1(Request $request, $programa)
    {
        if ($request->ajax()){

            DB::statement("SET lc_time_names = 'es_ES'");

            $data = DB::table('estudiantes AS e')
                ->join('planes AS pl', 'pl.id', '=', 'e.plan_id')
                ->join('programas AS pr', 'pr.id', '=', 'pl.program_id')
                ->where('e.estado', 1)
                ->where('pr.id', $programa)
                ->select('pl.nombre as nombre', DB::raw('COUNT(e.id) as total_estudiantes'))
                ->groupBy('pl.nombre')
                ->get();

            return response()->json($data);
        }

        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }

    public function grafica_2(Request $request, $programa)
    {
        if ($request->ajax()){

            DB::statement("SET lc_time_names = 'es_ES'");

            $data = DB::table('estudiantes AS e')
                ->join('planes AS pl', 'pl.id', '=', 'e.plan_id')
                ->join('programas AS pr', 'pr.id', '=', 'pl.program_id')
                ->where('e.estado', 2)
                ->where('pr.id', $programa)
                ->select('pl.nombre as nombre', DB::raw('COUNT(e.id) as total_egresados'))
                ->groupBy('pl.nombre')
                ->get();

            return response()->json($data);
        }

        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }

    public function grafica_3(Request $request, $programa)
    {
        if ($request->ajax()) {

            DB::statement("SET lc_time_names = 'es_ES'");
    
            $data = DB::table('semestres as s')
                ->leftJoin('matriculas_semestres as ms', 'ms.semester_id', '=', 's.id')
                ->select(
                    DB::raw("CONCAT(s.anho, '-', s.numero) as semestre"),
                    DB::raw('COUNT(DISTINCT ms.student_id) as total_matriculados')
                )
                ->groupBy('s.anho', 's.numero')
                ->orderBy('s.anho')
                ->orderBy('s.numero')
                ->get();
    
            return response()->json($data);
        }
    
        return response()->json([
            "status"  => false,
            "mensaje" => 'Error: no se pueden cargar los datos'
        ]);
    }
}