<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Encuesta;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class EncuestaController extends Controller
{
    public function index(Request $request)
    {

        return view('admin.bienestar.encuestas.encuesta.index');
    }

    public function list(Request $request, $opcion)
    {
        if ($request->ajax()) {
            if($opcion == "1"){
                $result = DB::table('encuestas AS e')
                ->join('planes AS pl', 'e.plan_id', '=', 'pl.id')
                ->select('e.id',
                                'e.plan_id',
                                'e.titulo',
                                'e.descripcion',
                                'e.fecha_inicio',
                                'e.fecha_fin', 'e.estado',
                                'e.dirigido_a', 'pl.nombre',
                                'pl.tipo')
                ->get();
            }else if($opcion == "2"){
                $result = DB::table('encuestas AS e')
                ->join('planes AS pl', 'e.plan_id', '=', 'pl.id')
                ->select( 'e.id',
                                'e.plan_id',
                                'e.titulo',
                                'e.descripcion',
                                'e.fecha_inicio',
                                'e.fecha_fin', 'e.estado',
                                'e.dirigido_a', 'pl.nombre',
                                'pl.tipo')
                ->where('e.estado', 'activa')
                ->get();
            }else{
                $result = DB::table('encuestas AS e')
                ->join('planes AS pl', 'e.plan_id', '=', 'pl.id')
                ->select('e.id',
                                'e.plan_id',
                                'e.titulo',
                                'e.descripcion',
                                'e.fecha_inicio',
                                'e.fecha_fin', 'e.estado',
                                'e.dirigido_a', 'pl.nombre',
                                'pl.tipo')
                ->where('e.fecha_fin', '<', now())
                ->get();
            }





            if ($result->isEmpty()) {
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Warnin, No hay registros',
                    "data" => []
                ]);
            } else {
                return response()->json([
                    "status" => true,
                    "mensaje" => 'SuccesFull, la consulta tiene registros encontrados',
                    "data" => $result
                ]);
            }
        }

        return response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function store(Request $request)
    {
        try {


            // Crear la nueva Encuesta
            $encuesta = new Encuesta();
            $encuesta->titulo = $request->input('text_titulo');
            $encuesta->plan_id = $request->input('txt-plans');
            if($request->input('select_estado') == '0'){
                $estado = 'inactiva';
            }else{
                $estado = $request->input('select_estado');

            }
            $encuesta->estado = $estado;
            $encuesta->dirigido_a = $request->input('dirigidoName');
            $encuesta->fecha_inicio = $request->input('fch_inicio');
            $encuesta->fecha_fin = $request->input('fch_fin');
            $encuesta->descripcion = $request->input('descripcionTxtArea');

            // Guardar la Encuesta en la base de datos
            if ($encuesta->save()) {
                return response()->json([
                    "status" => true,
                    "mensaje" => '¡Éxito! Encuesta registrada.',
                    "data" => $encuesta // Opcional: Devolver la Encuesta creada
                ], 201); // Código 201 para creación exitosa
            }

            // Respuesta en caso de error al guardar
            return response()->json([
                "status" => false,
                "mensaje" => 'Error al registrar la Encuesta. Inténtalo nuevamente.',
                "data" => $encuesta
            ], 500); // Código 500 para errores internos

        } catch (\Exception $e) {
            // Manejar excepciones inesperadas
            return response()->json([
                "status" => false,
                "mensaje" => 'Ocurrió un error inesperado.',
                "error" => $e->getMessage(), // Para debugging en desarrollo
            ], 500);
        }
    }


    public function update(Request $request, $id)
    {


        $item = Encuesta::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {


            $item->titulo = $request->input('text_titulo');
            $item->plan_id = $request->input('txt-plans');
            $item->estado = $request->input('select_estado');
            $item->dirigido_a = $request->input('dirigidoName');
            $item->fecha_inicio = $request->input('fch_inicio');
            $item->fecha_fin = $request->input('fch_fin');
            $item->descripcion = $request->input('descripcionTxtArea');

            if ($item->save()) {
                // El guardado fue exitoso
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                // El guardado falló
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id){
        // Busca el registro por su ID
        $encuesta = Encuesta::find($id);

        // Verifica si el registro existe
        if (!$encuesta) {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, el registro nos existe'
            ]);
        }

        // Elimina el registro de la base de datos
        if ($encuesta->delete()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'Éxito, el registro fue eliminado'
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, al eliminar registro'
            ]);
        }
    }
}
