<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\admin\Request;

class CourseequivalentExteriorController extends Controller
{
    public function list_by_institutions(): JsonResponse
    {
        $instituciones = DB::select('
            SELECT id,
                   name,
                   direccion,
                   contact,
                   created_at,
                   updated_at
            FROM instituciones AS i
            ORDER BY i.name ASC
        ');

        return response()->json($instituciones, 200);
    }

    public function storeExterna(Request $r): JsonResponse
    {
        $r->validate([
            'idprograma' => 'required|exists:programas,id',
            'plan_externo' => 'required|string|max:255',
            'tipo' => 'required|in:modular,transversal',
            'modalidad' => 'required|in:presencial,virtual,remoto',
            'enfoque' => 'required|in:presencial,virtual,remoto',
            'fecha' => 'required|date',
            'institucion_id' => 'required|exists:instituciones,id',
            'documento' => 'nullable|file|mimes:pdf,doc,docx|max:5120',
        ]);

        DB::beginTransaction();
        try {
            /* 1.  Crear el registro en planes_estudio_externos */
            $planExterno = \App\Models\PlanesEstudioExterno::create([
                'codigo_externo' => $r->plan_externo,
                'nombre' => $r->plan_externo,
                'tipo' => $r->tipo,
                'modalidad' => $r->modalidad,
                'enfoque' => $r->enfoque,
                'fecha' => $r->fecha,
                'institucion_id' => $r->institucion_id,
                'documento' => null, // lo llenamos después
            ]);

            /* 2.  Subir archivo (si viene) */
            if ($r->hasFile('documento')) {
                $path = $r->file('documento')
                    ->storeAs('equivalencias/externas',
                        'eq_ext_'.$planExterno->id.'.'.
                        $r->file('documento')->getClientOriginalExtension(),
                        'public');
                $planExterno->update(['documento' => $path]);
            }

            /* 3.  Crear la equivalencia propiamente tal */
            \App\Models\Planequivalence::create([
                'program_id' => $r->idprograma,
                'plan_id1' => null, // plan interno no aplica
                'plan_id2' => $planExterno->id, // el plan externo
                'documento' => $planExterno->documento,
            ]);

            DB::commit();

            return response()->json(['status' => true,
                'mensaje' => 'Equivalencia externa registrada']);
        } catch (\Throwable $e) {
            DB::rollBack();

            return response()->json(['status' => false,
                'mensaje' => $e->getMessage()], 500);
        }
    }
}
