<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Classroom;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;

class ClassroomController extends Controller
{
    //


    public function index(Request $request)
    {
        return view('admin.institucion.aulas.index');
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {
            $data = Classroom::query()
            ->from('aulas as a') // asegura el alias sobre la tabla real
            ->leftJoin('sedes as s', 's.id', '=', 'a.campus_id')
            ->select(
                'a.*',
                's.nombre as sede_nombre')
            ->orderBy('a.numero', 'asc')
            ->orderBy('a.tipo', 'desc')
            ->orderBy('a.piso', 'desc');

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function store(Request $request)
    {
        $item = new Classroom();
        $item->tipo = $request->input('txt_tipo_name');
        $item->campus_id = $request->input('txt_campus_id');
        $item->numero = $request->input('txt_numero_name');
        $item->piso = $request->input('txt_piso_name');
        $item->capacidad = $request->input('txt_capacidad_name');
        $item->ubicacion = $request->input('txt-ubicacion');
        $item->observacion = $request->input('txt-observacion');
        // Asigna otros campos según tus necesidades

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }


    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {
            $data = Classroom::all();
            return response()->json($data);
        }
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }


    public function update(Request $request, $id)
    {
        $item = Classroom::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->tipo = $request->input('txt_tipo_name');
            $item->campus_id = $request->input('txt_campus_id');
            $item->numero = $request->input('txt_numero_name');
            $item->piso = $request->input('txt_piso_name');
            $item->capacidad = $request->input('txt_capacidad_name');
            $item->ubicacion = $request->input('txt-ubicacion');
            $item->observacion = $request->input('txt-observacion');

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {
        // Busca el registro por su ID
        $item = Classroom::find($id);

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
