<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Campus;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use App\Models\Classroom;

class CampusController extends Controller
{
    //


    public function index(Request $request)
    {
        return view('admin.institucion.sedes.index');
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {
            $data = Campus::select([
                'id',
                'tipo_sede',
                'codigo',
                'nombre',
                'nombre_corto',
                'direccion',
                'telefono',
                'correo',
                'nombre_representante',
                'horas_servicio',
            ])
                ->get();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function store(Request $request)
    {
        $item = new Campus();
        $item->tipo_sede            = $request->input('txt-tipo_sede');
        $item->codigo               = $request->input('txt-codigo');
        $item->nombre               = $request->input('txt-nombre');
        $item->nombre_corto         = $request->input('txt-nombre_corto');
        $item->direccion            = $request->input('txt-direccion');
        $item->telefono             = $request->input('txt-telefono');
        $item->correo               = $request->input('txt-correo');
        $item->nombre_representante = $request->input('txt-nombre_representante');
        $item->horas_servicio       = $request->input('txt-horas_servicio');
        // Asigna otros campos según tus necesidades

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }

    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {
            $data = Campus::all();
            return response()->json($data);
        }
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }


    public function update(Request $request, $id)
    {
        $item = Campus::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->tipo_sede            = $request->input('txt-tipo_sede');
            $item->codigo               = $request->input('txt-codigo');
            $item->nombre               = $request->input('txt-nombre');
            $item->nombre_corto         = $request->input('txt-nombre_corto');
            $item->direccion            = $request->input('txt-direccion');
            $item->telefono             = $request->input('txt-telefono');
            $item->correo               = $request->input('txt-correo');
            $item->nombre_representante = $request->input('txt-nombre_representante');
            $item->horas_servicio       = $request->input('txt-horas_servicio');

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {
        // 1) Verificar existencia
        $campus = Campus::find($id);
        if (!$campus) {
            return response()->json(["status" => false, "mensaje" => "El registro no existe"]);
        }

        // 2) Verificar aulas asociadas (más eficiente con exists)
        $hasClassrooms = Classroom::where('campus_id', $campus->id)->exists();
        if ($hasClassrooms) {
            return response()->json([
                "status" => false,
                "mensaje" => "No se puede eliminar la sede porque tiene aulas asociadas"
            ]);
        }

        // 3) Eliminar
        $deleted = $campus->delete();
        return response()->json([
            "status" => (bool) $deleted,
            "mensaje" => $deleted ? "El registro fue eliminado" : "El registro no fue eliminado"
        ]);
    }
}
