<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Attention;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;

class AttentionController extends Controller
{
    public function index(Request $request)
    {
        return view('admin.centro_medico.atenciones.index');
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {
            $data = DB::table('atenciones AS ate')
            ->join('citas AS ci', 'ci.id', '=', 'ate.appointment_id')
            ->join('tipos_citas AS tci', 'tci.id', '=', 'ci.appointment_type_id')
            ->select(
                'ate.id',
                'ate.diagnostico',
                'ate.tratamiento',
                'ate.observaciones',
                'ci.asunto',
                'ci.descripcion',
                'ci.fecha_ini',
                'ci.fecha_fin',
                'ci.estado',
                'tci.nombre AS tipo_cita'
            )
            ->orderBy('ci.fecha_ini')
            ->orderBy('tci.nombre')
            ->get();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function store(Request $request)
    {
        $item = new Attention();
        $item->tipo = $request->input('txt_tipo_name');
        $item->numero = $request->input('txt_numero_name');
        $item->piso = $request->input('txt_piso_name');
        $item->capacidad = $request->input('txt_capacidad_name');
        $item->ubicacion = $request->input('txt-ubicacion');
        $item->observacion = $request->input('txt-observacion');
        // Asigna otros campos según tus necesidades

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }


    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {
            $data = Attention::all();
            return response()->json($data);
        }
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }


    public function update(Request $request, $id)
    {
        $item = Attention::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->tipo = $request->input('txt_tipo_name');
            $item->numero = $request->input('txt_numero_name');
            $item->piso = $request->input('txt_piso_name');
            $item->capacidad = $request->input('txt_capacidad_name');
            $item->ubicacion = $request->input('txt-ubicacion');
            $item->observacion = $request->input('txt-observacion');

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {
        // Busca el registro por su ID
        $item = Attention::find($id);

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
