<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;

class ApinetpeController extends Controller
{
    public function query_data($nroidenti)
{
    $token = 'sk_10995.b9jEoOn7Qa5u2xeq5Vo4j8khkR4BPim1';

    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => 'https://api.decolecta.com/v1/reniec/dni?numero=' . $nroidenti,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_SSL_VERIFYPEER => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token,
        ],
    ]);

    $response = curl_exec($curl);
    curl_close($curl);

    // === Mapear a las llaves ANTIGUAS que tu JS espera ===
    $decoded = json_decode($response, true) ?: [];

    if (isset($decoded['message'])) {
        // Deja pasar tal cual si es error (tu JS ya maneja 'message')
        return response()->json([
            "status"  => true,
            "mensaje" => 'Consulta realizada',
            "data"    => $response,
        ]);
    }

    $nombres = $decoded['first_name']        ?? null;
    $apePat  = $decoded['first_last_name']   ?? null;
    $apeMat  = $decoded['second_last_name']  ?? null;

    // Respaldo si solo llega full_name
    if ((!$nombres || !$apePat || !$apeMat) && !empty($decoded['full_name'])) {
        $partes = preg_split('/\s+/', trim($decoded['full_name']));
        if (count($partes) >= 3) {
            $apePat = $apePat ?: $partes[0];
            $apeMat = $apeMat ?: $partes[1];
            $nombres = $nombres ?: implode(' ', array_slice($partes, 2));
        }
    }

    $legacy = [
        'nombres'          => $nombres,
        'apellidoPaterno'  => $apePat,
        'apellidoMaterno'  => $apeMat,
        'numeroDocumento'  => $decoded['document_number'] ?? null,
    ];

    return response()->json([
        "status"  => true,
        "mensaje" => 'Consulta realizada',
        // Tu JS hace JSON.parse(response.data), así que envía string JSON
        "data"    => json_encode($legacy, JSON_UNESCAPED_UNICODE),
    ]);
}

public function query_data_ruc($ruc)
{
    $token = 'sk_10995.b9jEoOn7Qa5u2xeq5Vo4j8khkR4BPim1';

    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => 'https://api.decolecta.com/v1/sunat/ruc?numero=' . $ruc,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_SSL_VERIFYPEER => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            'Authorization: Bearer ' . $token,
        ],
    ]);

    $response = curl_exec($curl);
    curl_close($curl);

    $decoded = json_decode($response, true) ?: [];

    if (isset($decoded['message'])) {
        return response()->json([
            "status"  => true,
            "mensaje" => 'Consulta realizada',
            "data"    => $response,
        ]);
    }

    // Tu JS usa dataObj.nombre → mapeamos razon_social → nombre
    $legacy = [
        'nombre'            => $decoded['razon_social']     ?? null,
        'numero_documento'  => $decoded['numero_documento'] ?? null,
        'estado'            => $decoded['estado']           ?? null,
        'condicion'         => $decoded['condicion']        ?? null,
        'direccion'         => $decoded['direccion']        ?? null,
    ];

    return response()->json([
        "status"  => true,
        "mensaje" => 'Consulta realizada',
        "data"    => json_encode($legacy, JSON_UNESCAPED_UNICODE),
    ]);
}

}