<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Agreement;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class AgreementEfsrtController extends Controller
{

    public function index(Request $request)
    {
        return view('admin.institucion.convenios.index');
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {
            $data = DB::table('convenios_efsrt AS c')
            ->join('bt_empresas AS e', 'e.id', '=', 'c.company_id')
            ->select([
                'c.id AS idagreement',
                'c.fecha_inicio',
                'c.fecha_fin',
                'c.documento',
                DB::raw('COALESCE(c.descripcion, "") AS descripcion'),
                'e.id AS idcompany',
                'e.nombre',
                'e.ruc',
                DB::raw('CONCAT(e.ruc, " - ", e.nombre) AS empresa'),
                DB::raw('CONCAT("Del ", DATE_FORMAT(c.fecha_inicio, "%d/%m/%Y"), " al ", DATE_FORMAT(c.fecha_fin, "%d/%m/%Y")) AS vigencia')
            ])
            ->get();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function store(Request $request)
    {
        /*$validator = Validator::make($request->all(), [
            'txt_tipo_name' => 'required',
            'txt_numero_name' => 'required',
            'txt_piso_name' => 'required',
            'txt_capacidad_name' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                "status" => false,
                "errors" => $validator->errors()
            ]);
        }*/

        $item = new Agreement();
        $item->company_id = $request->input('txt-companies');
        $item->fecha_inicio = $request->input('txt-fecha_inicio');
        $item->fecha_fin = $request->input('txt-fecha_fin');
        $item->descripcion = $request->input('txt-descripcion');
        // Asigna otros campos según tus necesidades

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }


    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {
            $data = DB::table('convenios_efsrt as co')
            ->join('bt_empresas as em', 'co.company_id', '=', 'em.id')
            ->select(
                'co.id as idagreement',
                'co.company_id as idcompany',
                'co.fecha_inicio',
                'co.fecha_fin',
                'co.descripcion',
                DB::raw('CONCAT(em.ruc, " - ", em.nombre) as empresa')
            )
            ->get();

            return response()->json($data);
        }
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }


    public function update(Request $request, $id)
    {
        $item = Agreement::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->company_id = $request->input('txt-companies');
            $item->fecha_inicio = $request->input('txt-fecha_inicio');
            $item->fecha_fin = $request->input('txt-fecha_fin');
            $item->descripcion = $request->input('txt-descripcion');

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {
        // Busca el registro por su ID
        $item = Agreement::find($id);

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
