<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Admissionplan;
use App\Models\Logadmission;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class AdmissionplanController extends Controller
{


    public function store(Request $request, $idadmission)
    {

        // nuevo objeto
        $item = new Admissionplan();
        $item->admission_id = $idadmission;
        $item->plan_id = $request->input('txt-plans');
        $item->vacantes_ordinario = $request->input('txt-vacantes_ordinario');
        $item->vacantes_exoneracion = $request->input('txt-vacantes_exoneracion');
        $item->puntaje_minimo = $request->input('txt-puntaje_minimo');

        // validar guardado
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }



    public function update(Request $request, $id)
    {

        $item = Admissionplan::find($id);

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $item->vacantes_ordinario = $request->input('txt-vacantes_ordinario');
            $item->vacantes_exoneracion = $request->input('txt-vacantes_exoneracion');
            $item->puntaje_minimo = $request->input('txt-puntaje_minimo');
            // validar guardado
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {
        $item = Admissionplan::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }


    public function ajax_all_admissionplans(Request $request, $idadmission, $idprogram)
    {
        if ($request->ajax()) {
            
            $data = DB::table('admisiones_planes as ap')
            ->join('admisiones as ad', 'ad.id', '=', 'ap.admission_id')
            ->join('planes as pl', 'pl.id', '=', 'ap.plan_id')
            ->select(
                'pl.id as idplan', 
                'pl.nombre as nomplan', 
                'pl.tipo as tipo', 
                'pl.modalidad as modalidad', 
                'pl.enfoque as enfoque'
                )
            ->where('ad.id', '=', $idadmission)
            ->where('pl.program_id', '=', $idprogram)
            ->get();

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }
}
