<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Administrator;
use App\Models\Admission;
use App\Models\InfoInstitucional;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;
use App\Providers\AppServiceProvider;
use Carbon\Carbon;

class AdmissionController extends Controller
{
    //
    public function index(Request $request)
    {
        return view('admin.admision.admisiones.index');
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {
            DB::statement("SET lc_time_names = 'es_ES'");
            // query
            $data = DB::table('admisiones as ad')
                ->leftJoin('admisiones_planes as adpl', 'ad.id', '=', 'adpl.admission_id')
                ->leftJoin('planes as pl', 'adpl.plan_id', '=', 'pl.id')
                ->leftJoin('programas as pr', 'pl.program_id', '=', 'pr.id')
                ->select(
                    'ad.id as idadmission',
                    'ad.anho',
                    'ad.fecinicio',
                    'ad.fecfin',
                    'ad.fecfin_postulacion',
                    'ad.informacion',
                    DB::raw('DATE_FORMAT(ad.fecinicio, "%d - %M") as ffecinicio'),
                    DB::raw('DATE_FORMAT(ad.fecfin, "%d - %M") as ffecfin'),
                    'ad.estado',
                    'pr.id as idprogram',
                    'pr.codprograma AS codprograma',
                    'pr.nombre as nomprogram AS nomprograma',
                    'pr.nivel_formativo AS nivel_formativo',
                    'pl.id as idplan',
                    'pl.nombre as nomplan',
                    'pl.tipo',
                    'pl.modalidad',
                    'pl.enfoque',
                    'adpl.id as idadmissionplan',
                    'adpl.vacantes_ordinario',
                    'adpl.vacantes_exoneracion',
                    'adpl.puntaje_minimo'
                )
                ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }


    public function statistics(Request $request)
    {
        if ($request->ajax()) {

            $valor = $request->input('valor');
            $idplan = $request->input('idplan');

            if($valor == "genero") {
                $data = DB::table('admisiones AS a')
                    ->join('admisiones_planes AS ap', 'ap.admission_id', '=', 'a.id')
                    ->leftJoin('postulantes AS p', 'p.admissionplan_id', '=', 'ap.id')
                    ->join('generos AS g', 'g.id', '=', 'p.genre_id')
                    ->select('g.nombre AS dato', DB::raw('COALESCE(COUNT(g.id), 0) AS cantidad'))
                    ->where('a.id', $idplan)
                    ->groupBy('dato')
                    ->orderBy('cantidad', 'desc')
                    ->get();

            } else if ($valor == "edad") {

                $data = DB::table('admisiones AS a')
                    ->join('admisiones_planes AS ap', 'ap.admission_id', '=', 'a.id')
                    ->leftJoin('postulantes AS p', 'p.admissionplan_id', '=', 'ap.id')
                    ->select(DB::raw('CONCAT(TIMESTAMPDIFF(YEAR, p.fecnac, CURDATE()), " años") AS dato'), DB::raw('COUNT(p.id) AS cantidad'))
                    ->where('a.id', $idplan)
                    ->groupBy('dato')
                    ->orderBy('cantidad', 'desc')
                    ->get();
            
            } else if ($valor == "ubicacion") {
                
                $data = DB::table('admisiones AS a')
                ->join('admisiones_planes AS ap', 'ap.admission_id', '=', 'a.id')
                ->leftJoin('postulantes AS p', 'p.admissionplan_id', '=', 'ap.id')
                ->join('ubigeos AS ubi', 'ubi.id', '=', 'p.ubigeo_id')
                ->select(DB::raw('CONCAT(ubi.departamento, "-", ubi.provincia, "-", ubi.distrito) AS dato'), DB::raw('COUNT(p.id) AS cantidad'))
                ->where('a.id', $idplan)
                ->groupBy('dato')
                ->orderBy('cantidad', 'desc')
                ->get();
                
            } else {
                $data = [];
            }
            
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }


    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'txt-anho' => 'required',
            'txt-fecinicio' => 'required|date',
            'txt-fecfin' => 'required|date',
            'txt-fecfin_postulacion' => 'required|date',
            'txt-informacion' => 'required',
        ]);
        
        if ($validator->fails()) {
            return response()->json([
                "status" => false,
                "mensaje" => $validator->errors()->first(),
            ]);
        }
        
        // nuevo objeto
        $item = new Admission();
        $item->anho = $request->input('txt-anho');
        $item->fecinicio = $request->input('txt-fecinicio');
        $item->fecfin = $request->input('txt-fecfin');
        $item->fecfin_postulacion = $request->input('txt-fecfin_postulacion');
        $item->informacion = $request->input('txt-informacion');
        $item->estado = '1';
        
        // validar guardado
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }


    public function update(Request $request, $id)
    {
        $item = Admission::find($id);
        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            $fechaFinAdmission = Carbon::parse($item->fecfin);
            $fechaActual = Carbon::now();
            if ($fechaActual->lte($fechaFinAdmission) || $item->estado != 0) {
                // recoger datos
                $item->anho = $request->input('txt-anho');
                $item->fecinicio = $request->input('txt-fecinicio');
                $item->fecfin = $request->input('txt-fecfin');
                $item->fecfin_postulacion = $request->input('txt-fecfin_postulacion');
                $item->informacion = $request->input('txt-informacion');
                $item->estado = $request->input('txt-estado');
                // validar guardado
                if ($item->save()) {
                    return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
                }
            } else {
                // La fecha actual es mayor que la fecha de fin de la admision
                return response()->json([
                    "status" => false,
                    "mensaje" => 'El proceso de admisión ya finalizo'
                ]);
            }
        }
    }


    public function destroy($id)
    {
        $item = Admission::find($id);
        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }
        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }


    public function open_index(Request $request)
    {
        $InfoInstitucional = InfoInstitucional::find(1);

        return view('admin.admision.inscripcion_linea', [
            'institutions' => $InfoInstitucional,
        ]);
    }

    public function ajax_all_admission(Request $request)
    {
        if ($request->ajax()) {
            DB::statement("SET lc_time_names = 'es_ES'");
            // query
            $data = DB::table('admisiones as ad')
                ->leftJoin('admisiones_planes as adpl', 'ad.id', '=', 'adpl.admission_id')
                ->leftJoin('planes as pl', 'adpl.plan_id', '=', 'pl.id')
                ->leftJoin('programas as pr', 'pl.program_id', '=', 'pr.id')
                ->select(
                    'ad.id as idadmission',
                    'ad.anho as anho',
                    'ad.estado as estado',
                    'ad.fecfin_postulacion as fecfin_postulacion',
                    'ad.informacion as informacion',
                    'adpl.id as idadmissionplan',
                    'pr.id as idprogram',
                    'pr.codprograma AS codprograma',
                    'pr.nombre AS nomprograma',
                    'pr.nivel_formativo AS nivel_formativo',
                    'pl.id as idplan'
                )
                ->where('ad.estado', '=', 1)
                ->get();
            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }

    public function getInformation($id)
    {
        $admission = Admission::find($id);
        if ($admission) {
            return response()->json(["status" => true, "informacion" => $admission->informacion]);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no encontrado']);
        }
    }
}
