<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Administrator;
use App\Models\User;
use App\Models\Role;
use App\Models\Ubigeo;
use App\Services\Moodle\MoodleRoleService;
use App\Services\Moodle\MoodleUserService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Storage;
use PhpOffice\PhpSpreadsheet\IOFactory;
use Carbon\Carbon;

class AdministratorController extends Controller
{
    public function index(Request $request)
    {
        return view('admin.seguridad.administradores.index');
    }

    public function list(Request $request)
    {
        if ($request->ajax()) {
            // query
            $data = Administrator::join('roles AS r', 'r.id', '=', 'administradores.role_id')
                ->join('usuarios AS u', 'u.id', '=', 'administradores.user_id')
                ->join('tipos_identificaciones AS it', 'it.id', '=', 'u.identificationtype_id')
                ->join('tipos_usuarios AS ut', 'ut.id', '=', 'u.usertype_id')
                ->join('ubigeos AS ub', 'ub.id', '=', 'u.ubigeo_id')
                ->join('generos AS g', 'g.id', '=', 'u.genre_id')
                ->orderBy('u.apellido_pa', 'asc')
                ->orderBy('u.apellido_ma', 'asc')
                ->orderBy('u.nombres', 'asc')
                ->get([
                    'administradores.id AS idadministrador',
                    'r.id AS idrole', 'r.nombre AS nombrerole',
                    'u.id AS iduser', 'u.nroidenti', 'u.password', 'u.nombres', 'u.apellido_pa', 'u.apellido_ma', DB::raw('CONCAT(u.apellido_pa, " ", u.apellido_ma) AS apellidos'), 'u.fecnac', 'u.correo', 'u.telefono', 'u.celular', 'u.direccion', 'u.estado',
                    'it.id AS ididentificationtype', 'it.tipo AS tipoidenti',
                    'ut.id AS idusertype', 'ut.tipo',
                    'ub.id AS idubigeo', DB::raw('SUBSTRING(ub.id, 1, 2) AS iddepartamento'), 'ub.departamento', DB::raw('SUBSTRING(ub.id, 3, 2) AS idprovincia'), 'ub.provincia', DB::raw('SUBSTRING(ub.id, 5, 2) AS iddistrito'), 'ub.distrito',
                    'g.id AS idgenre', 'g.nombre AS nombregenre'
                ]);
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }


    public function store(Request $request)
    {
        function capitalizarArray($array)
        {
            return array_map(function ($elemento) {
                return ucwords(strtolower($elemento));
            }, $array);
        }

        $r_nroidenti = $request->input('txt_nroidenti');

        $usuario = User::where('nroidenti', $r_nroidenti)->first();

        if ($usuario) {
        $administrador = Administrator::where('user_id', $usuario->id)->first();
        }

        // VALIDAR SI EXISTE UN ADMINISTRADOR CON ESE NUMERO DE IDENTIFICACION
        if ($usuario && $administrador) {
            return response()->json(["status" => false, "mensaje" => 'El administrador ya está registrado']);
        }
        // SI NO EXISTE EL ADMINISTRADOR CON EL NUMERO DE IDENTIFICACION
        else {

            // SI EL USUARIO EXISTE
            if ($usuario) {

                // setear datos
                if ($usuario->usertype_id == '2') {
                    $new_usertype_id = 4;
                } else if ($usuario->usertype_id == '3') {
                    $new_usertype_id = 5;
                } else if ($usuario->usertype_id == '6') {
                    $new_usertype_id = 7;
                }
                $usuario->usertype_id = $new_usertype_id;
                $usuario->password = $request->input('txt_password');
                $usuario->estado = $request->input('txt_estado');
                $usuario->nombres = ucwords(strtolower($request->input('txt_nombres')));
                $usuario->apellido_pa = ucwords(strtolower($request->input('txt_apellido_pa')));
                $usuario->apellido_ma = ucwords(strtolower($request->input('txt_apellido_ma')));
                $usuario->fecnac = $request->input('txt_fecnac');
                $usuario->correo = $request->input('txt_correo');
                $usuario->telefono = $request->input('txt_telefono');
                $usuario->celular = $request->input('txt_celular');
                $usuario->genre_id = $request->input('txt_genre_id');
                $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
                $usuario->ubigeo_id = $idubigeo;
                $usuario->direccion = $request->input('txt_direccion');

                // validar guardado
                if ($usuario->save()) {
                    // recoger id insertado
                    $userId = $usuario->id;
                    // nuevo objeto
                    $item2 = new Administrator();
                    $item2->role_id = $request->input('txt_role_id');
                    $item2->user_id = $userId;

                    // validar guardado
                    if ($item2->save()) {
                        // // MOODLE ROLE SERVICE
                        // $moodleRoleService = new MoodleRoleService();
                        // $moodleRoleService->assignAdminRoleToUser($usuario->moodle_id);
                        // // MOODLE ROLE SERVICE
                        return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
                    } else {
                        return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                    }
                    return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                }
            }

            // SI EL USUARIO NO EXISTE
            else {

                // nuevo objeto
                $item = new User();
                // setear datos
                $item->identificationtype_id = $request->input('txt-identificationtype');
                $item->nroidenti = $request->input('txt_nroidenti');
                $item->password = $request->input('txt_password');
                $item->estado = $request->input('txt_estado');
                $item->nombres = ucwords(strtolower($request->input('txt_nombres')));
                $item->apellido_pa = ucwords(strtolower($request->input('txt_apellido_pa')));
                $item->apellido_ma = ucwords(strtolower($request->input('txt_apellido_ma')));
                $item->fecnac = $request->input('txt_fecnac');
                $item->correo = $request->input('txt_correo');
                $item->telefono = $request->input('txt_telefono');
                $item->celular = $request->input('txt_celular');
                $item->genre_id = $request->input('txt_genre_id');
                $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
                $item->ubigeo_id = $idubigeo;
                $item->direccion = $request->input('txt_direccion');
                $item->usertype_id = '1';

                // validar guardado
                if ($item->save()) {
                    // // MOODLE USER SERVICE
                    // $moodleUserService = new MoodleUserService();
                    // $mdlUsername = $item->nroidenti;
                    // // $mdlPassword = $item->password;
                    // $mdlPassword = "{$item->nroidenti}PE";
                    // $mdlFirstname = $item->nombres;
                    // $mdlLastname = "$item->apellido_pa $item->apellido_ma";
                    // $mdlEmail = $item->correo;
                    // $resultmdlUser = $moodleUserService->create($mdlUsername, $mdlPassword, $mdlFirstname, $mdlLastname, $mdlEmail);
                    // // Guardar Id de Moodle
                    if (isset($resultmdlUser[0]['id'])) {
                        // $item->moodle_id = $resultmdlUser[0]['id'];
                        $item->save();
                    }
                    // MOODLE USER SERVICE

                    // recoger id insertado
                    $newUserId = $item->id;
                    // nuevo objeto
                    $item2 = new Administrator();
                    $item2->role_id = $request->input('txt_role_id');
                    $item2->user_id = $newUserId;

                    // validar guardado
                    if ($item2->save()) {
                        // // MOODLE ROLE SERVICE
                        // $moodleRoleService = new MoodleRoleService();
                        // $moodleRoleService->assignAdminRoleToUser($item->moodle_id);
                        // // MOODLE ROLE SERVICE
                        return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
                    } else {
                        return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                    }

                    return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                }
            }
        }
    }


    public function update(Request $request, $id)
    {

        $item = User::find($id);

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $item->identificationtype_id = $request->input('txt-identificationtype');
            $item->nroidenti = $request->input('txt_nroidenti');
            $item->estado = $request->input('txt_estado');
            $item->genre_id = $request->input('txt_genre_id');
            $item->nombres = ucwords(strtolower($request->input('txt_nombres')));
            $item->apellido_pa = ucwords(strtolower($request->input('txt_apellido_pa')));
            $item->apellido_ma = ucwords(strtolower($request->input('txt_apellido_ma')));
            $item->fecnac = $request->input('txt_fecnac');
            $item->correo = $request->input('txt_correo');
            $item->telefono = $request->input('txt_telefono');
            $item->celular = $request->input('txt_celular');
            $item->direccion = $request->input('txt_direccion');
            $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
            $item->ubigeo_id = $idubigeo;
            // validar guardado
            if ($item->save()) {
                // nuevo objeto
                $item2 = new Administrator();

                $item2 = Administrator::where('user_id', $id)->first();
                // validar existencia del registro
                if (!$item2) {
                    abort(404);
                } else {
                    // recoger datos
                    $item2->role_id = $request->input('txt_role_id');
                    // validar guardado
                    if ($item2->save()) {
                        return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
                    } else {
                        return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
                    }
                }
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function update_password(Request $request, $id)
    {

        $item = User::find($id);

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $item->password = $request->input('txt_password2');
            // validar guardado
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {
        // Busca el registro por su ID
        $usuario = User::find($id);
        $idusertype = $usuario->usertype_id;

        // // MOODLE ROLE SERVICE
        // $moodleRoleService = new MoodleRoleService();
        // $moodleRoleService->unassignAdminRoleFromUser($usuario->moodle_id);
        // // MOODLE ROLE SERVICE

        // SI SOLO ES ADMINISTRADOR
        if ($idusertype == '1') {
            // validar existencia del registro
            if (!$usuario) {
                return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
            }

            // validar eliminación
            if ($usuario->delete()) {
                return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
            }
        }
        // SI TIENE OTROS ROLES
        else {
            // eliminar registro del administrador
            $administrador = Administrator::where('user_id', $usuario->id)->first();
            if (!$administrador) {
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Error, el registro no existe'
                ]);
            }
            // validar eliminación
            if ($administrador->delete()) {

                // actualizar tipo de usuario
                if ($idusertype == '4') {
                    $new_idusertype = 2;
                } else if ($idusertype == '5') {
                    $new_idusertype = 3;
                } else if ($idusertype == '7') {
                    $new_idusertype = 6;
                }
                $usuario->usertype_id = $new_idusertype;
                $usuario->save();

                return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
            }
        }
    }


    public function query_data($nroidenti)
    {
        $token = 'apis-token-6194.hK3hbzBDyBDl6XqMq1idxOEs8zNDv6AJ';

        // Iniciar llamada a API
        $curl = curl_init();

        // Buscar ruc sunat
        curl_setopt_array($curl, array(
            // para usar la versión 2
            CURLOPT_URL => 'https://api.apis.net.pe/v2/reniec/dni?numero=' . $nroidenti,
            // para usar la versión 1
            // CURLOPT_URL => 'https://api.apis.net.pe/v1/ruc?numero=' . $ruc,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => 0,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'Referer: http://apis.net.pe/api-ruc',
                'Authorization: Bearer ' . $token
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        // Datos de empresas según padron reducido

        return response()->json([
            "status" => true,
            "mensaje" => 'Consulta realizada',
            "data" => $response
        ]);
    }


    public function downloadExcelFile(Request $request)
    {
        $fileName = 'public/Plantillainscripciones/Plantilla_administradores.xlsx';

        // Verificar si el archivo existe
        if (Storage::disk('local')->exists($fileName)) {
            // Obtener el archivo del storage

            $file = storage_path('app/'.$fileName);
            $plantilla = IOFactory::load($file);
            $programa =  $request->input('txt_name_programa_title');
            $plan =  $request->input('txt_name_plan_title');
            $sheet = $plantilla->getActiveSheet();
            $sheet->setCellValue('B2', $programa)
                ->setCellValue('J2', $plan);

            // Establecer encabezados para forzar la descarga
            header("Content-Disposition: attachment; filename=" . $file);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Cache-Control: max-age=0');

            $writer = IOFactory::createWriter($plantilla, 'Xlsx');
            $writer->save('php://output');
        } else {
            // Mostrar un error
            return abort(404);
        }
    }


    public function store_plantilla(Request $request)
    {
        $columnas = $request->input('datajsondos');
        $countUsers = 0;
        $countAdministrators = 0;
        $countrepetido = 0;
        $miArraynroidentiRepet = [];

        foreach ($columnas as $columna) {
            // Verifica si el código de cargo existe
            $existeRole = Role::where('codigo', $columna[0])->exists();
            if (!$existeRole) {
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Hay códigos de cargos en la plantilla que no existen en el sistema'
                ]);
            }

            // Verifica si el número de documento ya está registrado
            $existeDni = User::where('nroidenti', $columna[1])->exists();
            if ($existeDni) {
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Hay números de identificación en la plantilla ya registrados'
                ]);
            }

            // Verifica si el correo ya está registrado
            $existeCorreo = User::where('correo', $columna[7])->exists();
            if ($existeCorreo) {
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Hay correos en la plantilla ya registrados'
                ]);
            }

            // Verifica si el ubigeo ya está registrado
            $existeUbigeo = Ubigeo::where('id', $columna[11])->exists();
            if (!$existeUbigeo) {
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Hay ubigeos que no existen en el sistema'
                ]);
            }
        }

        foreach ($columnas as $columna) {

            $user = User::where('nroidenti', $columna[3])->first();

            if ($user) {
                $countrepetido++;
                array_push($miArraynroidentiRepet, $columna[3]);
            } else {
                $item = new User();

                // TIPO IDENTI
                if ($columna[1] === 'DNI') {
                    $idtype = 1;
                } else if ($columna[1] === 'Carnét de Extranjería') {
                    $idtype = 2;
                }
                $item->identificationtype_id = $idtype;
                $item->nroidenti = $columna[2];
                $item->password = $columna[3];
                $item->nombres = $columna[4];
                $item->apellido_pa = $columna[5];
                $item->apellido_ma = $columna[6];
                $item->correo = $columna[7];
                $item->fecnac = Carbon::createFromDate(1900, 1, 1)->addDays($columna[8] - 2)->toDateString(); // Ajuste para fecha en Excel
                $item->telefono = $columna[9];
                $item->celular = $columna[10];
                $item->ubigeo_id = $columna[11];
                $item->direccion = $columna[12];
                $item->estado = "1";

                // GENERO
                if ($columna[13] === 'Masculino') {
                    $idgenre = '1';
                } else if ($columna[13] === 'Femenino') {
                    $idgenre = '2';
                } else if ($columna[13] === 'Otros') {
                    $idgenre = '3';
                }
                $item->genre_id = $idgenre;
                $item->usertype_id = '1';

                // validar guardado
                if ($item->save()) {
                    $countUsers++;
                    $newUserId = $item->id;
                    $item2 = new Administrator();
                    $role = Role::where('codigo', $columna[0])->first();
                    $item2->role_id = $role->id;
                    $item2->user_id = $newUserId;
                    // validar guardado
                    if ($item2->save()) {
                        $countAdministrators++;
                    }
                }
            }
        }

        if ($countUsers == count($columnas) && $countAdministrators == count($columnas)) {
            $result = ["status" => true, "mensaje" => 'Registros insertados correctamente'];
        } else if (($countUsers > 1 && $countrepetido > 1)) {
            $result = ["status" => true, "mensaje" => 'Registros Insertados: ' . $countUsers . ' Registros no insertados: ' . $countrepetido, "Repet" => $miArraynroidentiRepet];
        } else {
            $result = ["status" => false, "mensaje" => 'Error al insertar plantilla'];
        }
        return response()->json($result);
    }
}
