<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Activity;
use Illuminate\Http\Request;
use App\Models\Course;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class ActivityController extends Controller
{
    //
    public function store(Request $request)
    {
        $item = new Activity();
        $item->nombre = $request->input('txt-a_nombre');
        $item->indicator_id = $request->input('txt-a_idindicator');

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            // El guardado fue exitoso
            return response()->json([
                "status" => true,
                "mensaje" => 'Activity guardado'
            ]);
        } else {
            // El guardado falló
            return response()->json([
                "status" => false,
                "mensaje" => 'Activity no guardado'
            ]);
        }
    }

    public function update(Request $request, $id)
    {
        $item = Activity::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->nombre = $request->input('txt-a_nombre');

            if ($item->save()) {
                // El guardado fue exitoso
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                // El guardado falló
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {
        // Busca el registro por su ID
        $item = Activity::find($id);

        // Verifica si el registro existe
        if (!$item) {
            return response()->json([
                "status" => false,
                "mensaje" => 'El registro no existe'
            ]);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'El registro fue eliminado'
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'No se puede eliminar porque ya cuenta con registros asociados'
            ]);
        }
    }

}
