<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\NonAcademicActivity;
use App\Models\NonAcademicActivityDetail;
use Illuminate\Http\Request;
use App\Models\Teacher;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class ActividadesCnlController extends Controller
{


    public function store(Request $request)
    {

        $item = new NonAcademicActivity();
        $item->total_horas = $request->input('txt_timepo_nl');
        $item->nombre = $request->input('txt_actividad_nl');
        $item->descripcion = $request->input('text_descripcion');
        $item->estado ="activa";
        $item->docente_id = $request->input('text_hidden_iddocente');

        // validar guardado
        if ($item->save()) {


            // Si las opciones no están vacías
            foreach ($request->txt_dia_nl as $index => $txt_dia_nl) {
                NonAcademicActivityDetail::create([
                    'dia' => $txt_dia_nl,
                    'horaini' => $request->txt_horainicio_nl[$index],
                    'horafin' => $request->txt_horafin_nl[$index],
                    'duracion' => $request->duraciones[$index],
                    'actividad_cnl_id' => $item->id,

                ]);
            }


            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }

    public function update_actividades_cnl(Request $request, $id)
    {
        // Buscar la actividad principal usando el ID
        $item = NonAcademicActivity::find($id);

        // Verificar si la actividad existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'Actividad no encontrada']);
        }

        // Actualizar los datos de la actividad
        $item->total_horas = $request->input('txt_timepo_nl');
        $item->nombre = $request->input('txt_actividad_nl');
        $item->descripcion = $request->input('text_descripcion');
        $item->estado = "activa";

        // Validar si se guardan los cambios de la actividad
        if ($item->save()) {


            // Si las opciones de días no están vacías, actualizamos los detalles
            foreach ($request->txt_dia_nl as $index => $txt_dia_nl) {
                // Si el detalle tiene un ID (es un detalle existente), actualizamos, si no, creamos uno nuevo
                $detalleId = $request->id_detalle_a_nl[$index] ?? null;// Suponiendo que el input tiene un ID como 'detalle_id_0', 'detalle_id_1', etc.

                if ($detalleId) {
                    // Actualizar detalle existente
                    $detalle = NonAcademicActivityDetail::find($detalleId);
                    if ($detalle) {
                        $detalle->dia = $txt_dia_nl;
                        $detalle->horaini = $request->txt_horainicio_nl[$index];
                        $detalle->horafin = $request->txt_horafin_nl[$index];
                        $detalle->duracion = $request->duraciones[$index];
                        $detalle->save();
                    }
                } else {
                    // Crear un nuevo detalle si no existe ID
                    NonAcademicActivityDetail::create([
                        'dia' => $txt_dia_nl,
                        'horaini' => $request->txt_horainicio_nl[$index],
                        'horafin' => $request->txt_horafin_nl[$index],
                        'duracion' => $request->duraciones[$index],
                        'actividad_cnl_id' => $item->id,
                    ]);
                }
            }

            return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
        }
    }


    public function list(Request $request, $iduser)
    {
        if ($request->ajax()) {
            // query
            $data = Teacher::join('usuarios AS u', 'u.id', '=', 'docentes.user_id')
            ->leftJoin('actividades_cnl AS cnl', 'docentes.id', '=', 'cnl.docente_id')
            ->join('detalle_actividades_cnl AS dcnl', 'cnl.id', '=', 'dcnl.actividad_cnl_id')
            ->where('docentes.id', '=', $iduser)
            ->get([
                'docentes.id AS iddocente',
                'docentes.horas_nolectivas',
                'u.id AS iduser',
                'u.nombres',
                DB::raw('CONCAT(u.apellido_pa, " ", u.apellido_ma) AS apellidos'),
                'cnl.id AS idactividad_cnl',
                'cnl.nombre AS nombreactividad',
                'cnl.total_horas AS thoras_actividad',
                'cnl.descripcion',
                'dcnl.id AS iddetalle_actividad_cnl',
                'dcnl.dia',
                'dcnl.horaini',
                'dcnl.horafin',
                'dcnl.duracion',
            ]);



            // datatable
            return response()->json([
                "status" => true,
                "mensaje" => 'Consulta realizada',
                "data" =>$data
            ]);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function list_update(Request $request, $idregistro)
    {
        if ($request->ajax()) {
            // query
            $data = DB::table('actividades_cnl AS cnl')
            ->join('detalle_actividades_cnl AS dcnl', 'cnl.id', '=', 'dcnl.actividad_cnl_id')
            ->where('cnl.id', '=', $idregistro)
            ->get([
                'cnl.docente_id',
                'cnl.id AS idactividad_cnl',
                'cnl.nombre AS nombreactividad',
                'cnl.total_horas AS thoras_actividad',
                'cnl.descripcion',
                'dcnl.id AS iddetalle_actividad_cnl',
                'dcnl.dia',
                'dcnl.horaini',
                'dcnl.horafin',
                'dcnl.duracion',
            ]);

        // Organizar los datos en una estructura con actividad y detalles separados
        $actividad = null;
        $detalles = [];

        foreach ($data as $item) {
            // Agregar la actividad si aún no se ha asignado
            if (!$actividad) {
                $actividad = [
                    'docente_id' => $item->docente_id,
                    'idactividad_cnl' => $item->idactividad_cnl,
                    'nombreactividad' => $item->nombreactividad,
                    'thoras_actividad' => $item->thoras_actividad,
                    'descripcion' => $item->descripcion,
                ];
            }

            // Agregar los detalles a la lista
            $detalles[] = [
                'iddetalle_actividad_cnl' => $item->iddetalle_actividad_cnl,
                'dia' => $item->dia,
                'horaini' => $item->horaini,
                'horafin' => $item->horafin,
                'duracion' => $item->duracion,
            ];
        }

        // Enviar la respuesta estructurada
        return response()->json([
            "status" => true,
            "mensaje" => 'Consulta realizada',
            "actividad" => $actividad,
            "detalles" => $detalles
        ]);
       }
    }

    public function destroy_acnl($id)
    {
        // Busca el registro por su ID
        $actividadnl = NonAcademicActivity::find($id);

        // Verifica si el registro existe
        if (!$actividadnl) {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, el registro nos existe'
            ]);
        }

        // Elimina el registro de la base de datos
        if ($actividadnl->delete()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'Éxito, el registro fue eliminado'
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, al eliminar registro'
            ]);
        }
    }

    public function destroy_dacnl($id)
    {
        // Busca el registro por su ID
        $detalleactividanl = NonAcademicActivityDetail::find($id);

        // Verifica si el registro existe
        if (!$detalleactividanl) {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, el registro nos existe'
            ]);
        }

        // Elimina el registro de la base de datos
        if ($detalleactividanl->delete()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'Éxito, el registro fue eliminado'
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, al eliminar registro'
            ]);
        }
    }


}
