<?php

namespace App\Http\Controllers;

use App\Models\Td;
use Illuminate\Http\Request;

class TramiteDocumentarioController extends Controller
{
    public function findOneByCodigo($codigo)
    {
        [$serie, $dni, $numero] = explode('-', $codigo);

        $td = Td::where('serie', $serie . '-' . $dni)->where('numero', $numero)
            ->with(['area', 'td_estado', 'td_tipo', 'programa', 'td_tipo_solicitante', 'tipo_identificacion', 'area'])
            ->first();

        // SI NO EXISTE
        if (!$td) {
            return response()->json(["status" => false, "mensaje" => 'No se encuentra registro del trámite documentario']);
        }

        return response()->json([
            "status" => true,
            "mensaje" => 'Trámite Documentario encontrado',
            "data_td" => $td
        ]);
    }

    public function index_consulta()
    {
        return view('tramite_documentario.consulta.index');
    }
}
