<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Laravel\Socialite\Facades\Socialite;

class LoginMicrosoftController extends Controller
{
    public function login()
    {
        $user = Socialite::driver('microsoft')->user();
        $userExists = User::where('correo', $user->email)->first();

        if ($userExists) {
            Auth::login($userExists);
        } else {
            return redirect()->route('login')->with('error', 'El correo proporcionado no está asociado con ningún usuario registrado.');
        }

        if (Auth::user()->estado != 1) {
            Auth::logout();
            return redirect()->route('login')->with('error', 'Usuario inactivo, consulte con el administrador.');
        }

        $loggedUser = Auth::User();
        $ruta = 'login';

        if ($loggedUser->administradores->isNotEmpty()) {
            $ruta = 'home.adm.dashboard';
            session()->put('loggedUserType', 'admin');
        } else if ($loggedUser->teachers->isNotEmpty()) {
            $ruta = 'home.docente.index';
            session()->put('loggedUserType', 'teacher');
        } else if ($loggedUser->students->isNotEmpty()) {
            $ruta = 'home.student.index';
            session()->put('loggedUserType', 'student');
        }

        return redirect()->route($ruta);
    }
}
