<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Laravel\Socialite\Facades\Socialite;

class LoginGoogleController extends Controller
{
    function login()
    {
        $user = Socialite::driver('google')->user();
        // $userExists = User::where('google_id', $user->id)->where('external_auth','google')->first();
        $userExists = User::where('correo', $user->email)->first();

        if ($userExists) {
            Auth::login($userExists);
        } else {
            return redirect()->route('login')->with('error', 'El correo proporcionado no está asociado con ningún usuario registrado.');
            // return response()->json([
            //     "status" => false,
            //     "message" => "El correo de usuario no esta asociado con ningun correo",
            // ]);
        }


        if (Auth::User()->estado != 1) {
            Auth::logout(); // Cerrar sesión si el usuario no está activo
            return redirect()->route('login');
            return response()->json([
                "status" => false,
                "message" => "Usuario inactivo, consulte con el administrador!"
            ]);
        }

        $loggedUser = Auth::User();
        $ruta = 'login';

        if ($loggedUser->administradores->isNotEmpty()) {
            $ruta = 'home.adm.dashboard';
            session()->put('loggedUserType', 'admin');
        } else if ($loggedUser->teachers->isNotEmpty()) {
            $ruta = 'home.docente.index';
            session()->put('loggedUserType', 'teacher');
        } else if ($loggedUser->students->isNotEmpty()) {
            $ruta = 'home.student.index';
            session()->put('loggedUserType', 'student');
        }

        return redirect()->route($ruta);
    }
}
