<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Http\Controllers\paggeAccess\PageAccessController;
use App\Http\Controllers\sidebar\SidebarController;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;

use App\Models\Firstuserlogin;
use App\Models\User;
use App\Services\AuthService;
use Illuminate\Support\Facades\Session;
use App\Services\TramitesService;
use Illuminate\Support\Str;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;

class LoginController extends Controller
{

    //INYECCION DE DEPENDENCIA
    protected $tramites;

    public function __construct(TramitesService $tramites)
    {
        $this->tramites = $tramites;
    }

    public function index()
    {

        $statusmodule = $this->tramites->estadomodulotramitedocumentario();

        // Verifica si la página está habilitada
        if ($statusmodule) {
            view()->share('module', true);
        } else {
            view()->share('module', false);
        }
        return view('welcome');
    }

    public function forgotPasswordView()
    {
        $statusmodule = $this->tramites->estadomodulotramitedocumentario();

        if ($statusmodule) {
            view()->share('module', true);
        } else {
            view()->share('module', false);
        }

        return view('auth.forgot-password');
    }

    public function resetPasswordView(Request $request)
    {
        $statusmodule = $this->tramites->estadomodulotramitedocumentario();

        if ($statusmodule) {
            view()->share('module', true);
        } else {
            view()->share('module', false);
        }

        $token = $request->query('token');
        $email = $request->query('email');
        if (!$token || !$email) {
            abort(404, 'Token o email no proporcionado.');
        }

        return view('auth.reset-password', [
            'token' => $token,
            'email' => $email,
        ]);
    }


    public function registration()
    {
        return view('auth.register');
    }

    public function profileLogin(Request $request)
    {
        $ruta_login = 'login';
        $user = Auth::user();

        if ($user->estado != 1) {
            (new AuthService())->logout($request);
            return response()->json([
                "status" => false,
                "message" => "Usuario inactivo, consulte con el administrador!",
                "redirect" => route($ruta_login),
            ]);
        }

        // OBTENER TIPO DE USUARIO
        $type = $request->input('tipoUsuarioLogin');

        if ($type == 'admin') {
            if ($user->administradores->isNotEmpty()) {
                $ruta = 'home.adm.dashboard';
                $request->session()->put('loggedUserType', 'admin');
            }
        } else if ($type == 'teacher') {
            if ($user->teachers->isNotEmpty()) {
                $ruta = 'home.docente.index';
                $request->session()->put('loggedUserType', 'teacher');
            }
        } else if ($type == 'student') {
            if ($user->students->isNotEmpty()) {
                $ruta = 'home.student.index';
                $request->session()->put('loggedUserType', 'student');
            }
        } else {
            (new AuthService())->logout($request);
            return response()->json([
                "status" => false,
                "message" => "Acceso denegado!",
                "redirect" => route($ruta_login)
            ]);
        }

        //si el usuario esta autentificado y esta activo
        return response()->json([
            "status" => true,
            "message" => "Acceso autorizado",
            "redirect" => route($ruta)
        ]);
    }


    public function authenticateLogin(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'nroidenti' => 'required|min:6|max:12',
            'password' => 'required'
        ], [
            'nroidenti.min' => 'El código no cuenta con la cantidad de carácteres requeridos',
            'nroidenti.max' => 'El código no cuenta con la cantidad de carácteres requeridos',
        ]);

        // falla validacion
        if ($validator->fails()) {
            return response()->json([
                "status" => false,
                "errors" => $validator->errors(),
                "message" => "Digite bien los campos!",
            ]);
        }

        // fallan credenciales
        if (!Auth::attempt($request->only(['nroidenti', 'password']))) {
            return response()->json([
                "status" => false,
                "errors" => ["Credenciales inválidas"],
                "message" => "Credenciales inválidas!",
            ]);
        }

        $user = Auth::user();

        // falla estado usuario
        if ($user->estado != 1) {
            Auth::logout();
            return response()->json([
                "status" => false,
                "message" => "Usuario inactivo, consulte con el administrador!",
            ]);
        }

        $ruta = 'login';
        $hasRedirect = false;
        $userRoles = [];

        if ($user->administradores->isNotEmpty()) {
            $hasRedirect = true;
            $ruta = 'home.adm.dashboard';
            $request->session()->put('loggedUserType', 'admin');
        } else if ($user->teachers->isNotEmpty()) {
            $hasRedirect = true;
            $ruta = 'home.docente.index';
            $request->session()->put('loggedUserType', 'teacher');
        } else if ($user->students->isNotEmpty()) {
            $hasRedirect = true;
            $ruta = 'home.student.index';
            $request->session()->put('loggedUserType', 'student');
        } else {
            $userRoles = [];
        }

        // return response()->json([
        //     "status" => false,
        //     "errors" => ["Acceso denegado"],
        //     "message" => "Error login autentcacion",
        //     "userRoles" => $userRoles,
        //     "hasRedirect" => $hasRedirect,
        //     "redirect" => route($ruta)
        // ]);

        //si el usuario esta autentificado y esta activo
        return response()->json([
            "status" => true,
            "message" => "Credenciales correctas",
            "userRoles" => $userRoles,
            "hasRedirect" => $hasRedirect,
            "redirect" => route($ruta)
        ]);
    }


    public function dashboard(Request $request)
    {
        $result = Firstuserlogin::where('nroidenti', Auth::User()->nroidenti)->first();

        if ($result) {
            view()->share('modal_mensajeversion', false);
        } else {
            view()->share('modal_mensajeversion', true);
        }

        return view('home.adm.dashboard');
    }


    public function homeDocentes(Request $request)
    {
        $result = Firstuserlogin::where('nroidenti', Auth::User()->nroidenti)->first();

        if ($result) {
            view()->share('modal_mensajeversion', false);
        } else {
            view()->share('modal_mensajeversion', true);
        }

        return view('home.docente.index');
    }


    public function homeStudent(Request $request)
    {
        $result = Firstuserlogin::where('nroidenti', Auth::User()->nroidenti)->first();

        if ($result) {
            view()->share('modal_mensajeversion', false);
        } else {
            view()->share('modal_mensajeversion', true);
        }

        return view('home.student.index');
    }


    public function confirmarNotificacionUpdateVersion(Request $request)
    {

        $item = new Firstuserlogin();
        $item->nroidenti = Auth::User()->nroidenti;
        $item->estado = "1";
        if ($item->save()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'Noticación Recibida',
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'Noticación no Recibida'
            ]);
        }
    }


    public function logout(Request $request)
    {
        (new AuthService())->logout($request);

        return response()->json([
            "status" => true,
            "message" => "Cerrando sesion",
            "redirect" => route('login')
        ]);
    }

    public function changeLoginType($type, Request $request)
    {
        $ruta_login = 'login';
        $user = Auth::user();

        if ($user->estado != 1) {
            (new AuthService())->logout($request);
            return response()->json([
                "status" => false,
                "message" => "Usuario inactivo, consulte con el administrador!",
                "redirect" => route($ruta_login),
            ]);
        }

        if ($type == 'admin') {
            if ($user->administradores->isNotEmpty()) {
                $ruta = 'home.adm.dashboard';
                $request->session()->put('loggedUserType', 'admin');
            }
        } else if ($type == 'teacher') {
            if ($user->teachers->isNotEmpty()) {
                $ruta = 'home.docente.index';
                $request->session()->put('loggedUserType', 'teacher');
            }
        } else if ($type == 'student') {
            if ($user->students->isNotEmpty()) {
                $ruta = 'home.student.index';
                $request->session()->put('loggedUserType', 'student');
            }
        } else {
            (new AuthService())->logout($request);
            return response()->json([
                "status" => false,
                "message" => "Acceso denegado!",
                "redirect" => route($ruta_login)
            ]);
        }


        //si el usuario esta autentificado y esta activo
        return response()->json([
            "status" => true,
            "message" => "Acceso autorizado",
            "redirect" => route($ruta)
        ]);
    }

    // olvidaste contraseña
    public function forgotPassword(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email|exists:usuarios,correo',
        ], [
            'email.exists' => 'El correo no está registrado en el sistema.',
        ]);

        if ($validator->fails()) {
            return response()->json([
                "status" => false,
                "errors" => $validator->errors(),
                "mensaje" => "Correo no válido."
            ]);
        }

        $email = $request->email;
        $token = Str::random(64);

        // upsert token
        DB::table('password_reset_tokens')->updateOrInsert(
            ['email' => $email],
            [
                'token' => Hash::make($token),
                'created_at' => Carbon::now()
            ]
        );

        // envia mail
        Mail::send('mail.forgot-password', ['token' => $token, 'email' => $email], function ($message) use ($email) {
            $message->to($email);
            $message->subject('Recupera tu contraseña');
        });

        return response()->json([
            "status" => true,
            "mensaje" => "Hemos enviado un enlace de recuperación a tu correo."
        ]);
    }

    // resetea contraseña
    public function resetPassword(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email|exists:usuarios,correo',
            'token' => 'required|string',
            'password' => 'required|confirmed|min:8',
        ]);

        if ($validator->fails()) {
            return response()->json([
                "status" => false,
                "errors" => $validator->errors(),
                "mensaje" => "Error de validación."
            ]);
        }

        $record = DB::table('password_reset_tokens')->where('email', $request->email)->first();

        if (!$record) {
            return response()->json([
                "status" => false,
                "mensaje" => "Solicitud no encontrada o ya utilizada."
            ]);
        }

        // valida token
        if (!Hash::check($request->token, $record->token)) {
            return response()->json([
                "status" => false,
                "mensaje" => "Solicitud inválida."
            ]);
        }

        // valida hora de expiración
        if (Carbon::parse($record->created_at)->diffInMinutes(now()) > 60) {
            DB::table('password_reset_tokens')->where('email', $request->email)->delete();
            return response()->json([
                "status" => false,
                "mensaje" => "La solicitud ha expirado. Solicita una nueva."
            ]);
        }

        // cambia la contraseña
        $user = User::where('correo', $request->email)->first();
        $user->password = $request->password;
        $user->save();

        // elimina el token usado
        DB::table('password_reset_tokens')->where('email', $request->email)->delete();

        return response()->json([
            "status" => true,
            "mensaje" => "Tu contraseña ha sido restablecida correctamente."
        ]);
    }
}
