<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Socioeconomicsheet;
use App\Models\Student;
use App\Models\User;
use Illuminate\Http\Request;

class FichaSocioeconomicaController extends Controller
{
    // WEB
    public function index()
    {
        return view('ficha_socioeconomica.index');
    }

    // API
    public function upsert(Request $request)
    {
        $idStudent = $request->input('txt_idstudent');

        $fichaSocioeconomica = Socioeconomicsheet::where('student_id', $idStudent)->first();
        if (!$fichaSocioeconomica) {
            return $this->store($request);
        } else {
            return $this->update($fichaSocioeconomica->id, $request);
        }
    }

    public function store(Request $request)
    {
        $idStudent = $request->input('txt_idstudent');
        // return response()->json(["status" => false, "mensaje" => "Store $idStudent"]);

        $newFichaSocioeconomica = new Socioeconomicsheet();

        $newFichaSocioeconomica->estado_civil = $request->input('txt_civil');
        $newFichaSocioeconomica->nro_hijos = $request->input('txt_numhijos');
        $newFichaSocioeconomica->tipovivienda = $request->input('txt_tipovivienda');
        $newFichaSocioeconomica->gastos_mensuales = $request->input('txt_gastos');
        $newFichaSocioeconomica->carrera_satis_necesi = $request->input('txt_satisface');
        $newFichaSocioeconomica->area_carrera_profesiona_beneficiado = $request->input('txt_beneficiado');
        $newFichaSocioeconomica->satisfecho_form_institu_brindo = $request->input('txt_conforme');
        $newFichaSocioeconomica->motivos_satisfecho_form_institu_brindo = $request->input('txt_motivos');
        $newFichaSocioeconomica->razon_form_institu_brindo = $request->input('txt_motivos_razon');

        $newFichaSocioeconomica->flg_trabaja = $request->input('txt_trabaja');
        if ($request->input('txt_trabaja') == "si") {
            $newFichaSocioeconomica->empresa = $request->input('txt_nomempresa');
            $newFichaSocioeconomica->tipo_empresa = $request->input('txt_tipoempresa');
            $newFichaSocioeconomica->ingreso_mensual = $request->input('txt_remuneracion');
            $newFichaSocioeconomica->rubro_empresa = $request->input('txt_rubro');
            $newFichaSocioeconomica->nombre_jefe = $request->input('txt_jefe');
            $newFichaSocioeconomica->ocupacion = $request->input('txt_cargo');
            $newFichaSocioeconomica->forma_contrato = $request->input('txt_formacontrato');
        } else {
            $newFichaSocioeconomica->empresa = '';
            $newFichaSocioeconomica->tipo_empresa = '';
            $newFichaSocioeconomica->ingreso_mensual = 0;
            $newFichaSocioeconomica->rubro_empresa = '';
            $newFichaSocioeconomica->nombre_jefe = '';
            $newFichaSocioeconomica->ocupacion = '';
            $newFichaSocioeconomica->forma_contrato = '';
        }

        $newFichaSocioeconomica->flg_antes_trabajaba = $request->input('txt_anteriormente');
        if ($request->input('txt_anteriormente') == "si") {
            $newFichaSocioeconomica->meses_no_trabaja = $request->input('txt_negativopositivo');
            $newFichaSocioeconomica->form_prof_recibida = $request->input('txt_explicacionlaboral');
            $newFichaSocioeconomica->explicacion = $request->input('txt_porque');
        } else {
            $newFichaSocioeconomica->meses_no_trabaja = '';
            $newFichaSocioeconomica->form_prof_recibida = '';
            $newFichaSocioeconomica->explicacion = '';
        }

        $newFichaSocioeconomica->student_id = $idStudent;

        if ($newFichaSocioeconomica->save()) {
            return response()->json(["status" => true, "mensaje" => 'Ficha socioeconomica registrada']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }


    public function findOneByStudent($studentId)
    {
        $fichaSocioeconomica = Socioeconomicsheet::where('student_id', $studentId);
        return $fichaSocioeconomica;
    }

    public function findOneByNroDocumento($nroDocumento)
    {
        $user = User::with(['students.plan.program'])->where('nroidenti', $nroDocumento)->first();

        // SI NO EXISTE EL NRO DE DOCUMENTO ASOCIADO A UN USUARIO
        if (!$user) {
            return response()->json(["status" => false, "mensaje" => 'No se encuentra el nro de documento']);
        }

        $students = $user->students;
        // SI EL USUARIO NO ES ESTUDIANTE
        if (count($students) <= 0) {
            return response()->json(["status" => false, "mensaje" => 'El nro de documento no está registrado como estudiante']);
        }

        $student = $students[0];
        $idStudent = $student->id;
        $estadoStudent = $student->estado;

        // SI EL ESTUDIANTE NO ES EGRESADO
        if ($estadoStudent != 5) {
            return response()->json(["status" => false, "mensaje" => 'El estudiante no se encuentra registrado como egresado']);
        }

        $fichaSocioeconomica = Socioeconomicsheet::where('student_id', $idStudent)->first();

        // SI EL ESTUDIANTE NO TIENE UNA FICHA SOCIOECONOMICA
        if (!$fichaSocioeconomica) {
            return response()->json([
                "status" => true,
                "ficha_socioeconomica" => false,
                "data_user" => $user,
                "mensaje" => 'No tiene una ficha socioeconomica registrada'
            ]);
        }

        return response()->json([
            "status" => true,
            "ficha_socioeconomica" => true,
            "data_user" => $user,
            "data_ficha" => $fichaSocioeconomica,
            "mensaje" => 'Ya cuenta con una ficha registrada, puede actualizar su data si lo requiere'
        ]);

        return response()->json(["status" => false, "mensaje" => 'No se pudo realizar consulta']);
    }

    public function findOne($id)
    {
        $fichaSocioeconomica = Socioeconomicsheet::find($id);
        return $fichaSocioeconomica;
    }

    public function update($id, Request $request)
    {
        $idStudent = $request->input('txt_idstudent');
        // return response()->json(["status" => false, "mensaje" => "Update $idStudent"]);

        $fichaSocioeconomica = Socioeconomicsheet::find($id);

        if (!$fichaSocioeconomica) {
            abort(404); // Manejo de error si no se encuentra el registro
        }

        $fichaSocioeconomica->estado_civil = $request->input('txt_civil');
        $fichaSocioeconomica->nro_hijos = $request->input('txt_numhijos');
        $fichaSocioeconomica->tipovivienda = $request->input('txt_tipovivienda');
        $fichaSocioeconomica->gastos_mensuales = $request->input('txt_gastos');
        $fichaSocioeconomica->carrera_satis_necesi = $request->input('txt_satisface');
        $fichaSocioeconomica->area_carrera_profesiona_beneficiado = $request->input('txt_beneficiado');
        $fichaSocioeconomica->satisfecho_form_institu_brindo = $request->input('txt_conforme');
        $fichaSocioeconomica->motivos_satisfecho_form_institu_brindo = $request->input('txt_motivos');
        $fichaSocioeconomica->razon_form_institu_brindo = $request->input('txt_motivos_razon');

        $fichaSocioeconomica->flg_trabaja = $request->input('txt_trabaja');
        if ($request->input('txt_trabaja') == "si") {
            $fichaSocioeconomica->empresa = $request->input('txt_nomempresa');
            $fichaSocioeconomica->tipo_empresa = $request->input('txt_tipoempresa');
            $fichaSocioeconomica->ingreso_mensual = $request->input('txt_remuneracion');
            $fichaSocioeconomica->rubro_empresa = $request->input('txt_rubro');
            $fichaSocioeconomica->nombre_jefe = $request->input('txt_jefe');
            $fichaSocioeconomica->ocupacion = $request->input('txt_cargo');
            $fichaSocioeconomica->forma_contrato = $request->input('txt_formacontrato');
        } else {
            $fichaSocioeconomica->empresa = '';
            $fichaSocioeconomica->tipo_empresa = '';
            $fichaSocioeconomica->ingreso_mensual = 0;
            $fichaSocioeconomica->rubro_empresa = '';
            $fichaSocioeconomica->nombre_jefe = '';
            $fichaSocioeconomica->ocupacion = '';
            $fichaSocioeconomica->forma_contrato = '';
        }

        $fichaSocioeconomica->flg_antes_trabajaba = $request->input('txt_anteriormente');
        if ($request->input('txt_anteriormente') == "si") {
            $fichaSocioeconomica->meses_no_trabaja = $request->input('txt_negativopositivo');
            $fichaSocioeconomica->form_prof_recibida = $request->input('txt_explicacionlaboral');
            $fichaSocioeconomica->explicacion = $request->input('txt_porque');
        } else {
            $fichaSocioeconomica->meses_no_trabaja = '';
            $fichaSocioeconomica->form_prof_recibida = '';
            $fichaSocioeconomica->explicacion = '';
        }

        $fichaSocioeconomica->student_id = $idStudent;

        if ($fichaSocioeconomica->save()) {
            return response()->json(["status" => true, "mensaje" => 'Ficha socioeconomica actualizada']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
        }
    }


    public function destroy($id)
    {
        return 'delete';
    }
}
