<?php

namespace App\Http\Controllers;

use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Efsrt;
use App\Models\EfsrtEstudiante;
use App\Models\Trainingmodule;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class EfsrtController extends Controller
{

    public function index(Request $request)
    {
        return view('admin.efsrt.index');
    }


    public function store(Request $request)
    {
        $newEfsrt = new Efsrt();

        $newEfsrt->student_id  = $request->input('add_student_id');
        $newEfsrt->module_training_id = $request->input('add_modulo_formativo_id');
        $newEfsrt->total_horas = $request->input('add_total_horas');
        $newEfsrt->estado = 0;

        if ($newEfsrt->save()) {
            return response()->json(["status" => true, "mensaje" => 'Efsrt registrado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }

    public function store_detail(Request $request)
    {
        $newEfsrt = new EfsrtEstudiante();

        $newEfsrt->efsrt_id  = $request->input('add_det_efsrt_id');
        $newEfsrt->agreement_id = $request->input('add_det_convenio');
        $newEfsrt->horas = $request->input('add_det_horas');
        $newEfsrt->estado = 1;

        if ($newEfsrt->save()) {
            return response()->json(["status" => true, "mensaje" => 'Detalle Efsrt registrado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }

    public function destroy($id)
    {
        // Busca el registro por su ID
        $efsrt = Efsrt::find($id);

        // Verifica si el registro existe
        if (!$efsrt) {
            return response()->json([
                "status" => false,
                "mensaje" => 'El registro no existe'
            ]);
        }

        // Elimina el registro de la base de datos
        if ($efsrt->delete()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'El registro fue eliminado'
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'No se puede eliminar porque ya cuenta con registros asociados'
            ]);
        }
    }

    public function list($planId, $studentId)
    {
        // $planId = 0;
        // $studentId = 0;

        // Si los IDs son 0, retorna las cabeceras vacías
        if ($planId == 0 || $studentId == 0) {
            return [];
        }

        return DB::table('modulos_formativos as mf')
            ->select([
                'mf.id as mf_id',
                'mf.numero as mf_numero',
                'mf.codigo as mf_codigo',
                'mf.descripcion as mf_descripcion',
                DB::raw('IF(ef.id IS NOT NULL, 1, 0) as ef_existe'),
                'ef.id as ef_id',
                'ef.student_id as student_id',
                'ef.total_horas as ef_total_horas',
                'ef.estado as ef_estado',
            ])
            ->leftJoin('efsrts as ef', function ($join) use ($studentId) {
                $join->on('mf.id', '=', 'ef.module_training_id')
                    ->where('ef.student_id', $studentId);
            })
            ->where('mf.plan_id', $planId)
            ->get();
    }


    public function dt_list(Request $request)
    {
        $planId  = $request->input('plan_id');
        $studentId  = $request->input('student_id');

        $data = $this->list($planId, $studentId);

        return \Yajra\DataTables\DataTables::of($data)
            ->addIndexColumn()
            ->make(true);
    }

    public function listWithDetails($efsrtId)
    {
        // $efsrtId = 1;

        if ($efsrtId == 0) {
            return [];
        }

        return DB::table('efsrt_estudiantes as efdet')
            ->select([
                'efdet.id as efdet_id',
                'efdet.horas as efdet_horas',
                'efdet.estado as efdet_estado',
                DB::raw("DATE_FORMAT(efdet.created_at, '%Y-%m-%d') as efdet_fecha"),
                'con.id as con_id',
                'emp.nombre as con_nombre',
            ])
            ->join('convenios_efsrt as con', 'efdet.agreement_id', '=', 'con.id')
            ->join('bt_empresas as emp', 'con.company_id', '=', 'emp.id')
            ->where('efdet.efsrt_id', $efsrtId)
            ->orderByDesc('efdet.created_at')
            ->get();
    }

    public function dt_listWithDetails(Request $request)
    {
        $efsrtId  = $request->input('efsrt_id');

        $data = $this->listWithDetails($efsrtId);

        return \Yajra\DataTables\DataTables::of($data)
            ->addIndexColumn()
            ->make(true);
    }

    public function findOneWithDetails($efsrtId)
    {
        $efsrt = Efsrt::with(['estudiante.user', 'modulo_formativo.plan.program'])->find($efsrtId);
        // $efsrt = EfsrtEstudiante::with(['efsrt.estudiante.user', 'efsrt.modulo_formativo.plan.program'])->where('efsrt_id', $efsrtId)->first();

        $horasSumadas = EfsrtEstudiante::where('efsrt_id', $efsrtId)->where('estado', 1)->sum('horas');
        if ($horasSumadas == 0) {
            $porcentaje = 0;
        } else if ($horasSumadas > $efsrt->total_horas) {
            $porcentaje = 100;
        } else {
            $porcentaje = ($horasSumadas / $efsrt->total_horas) * 100;
        }

        $efsrt->porcentaje_total = $porcentaje;

        return response()->json([
            "status" => true,
            "data" => $efsrt,
        ]);;
    }

    public function destroyEfsrtDetalle($efsertDet_id)
    {
        // Busca el registro por su ID
        $item = EfsrtEstudiante::find($efsertDet_id);
        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }
        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }

    public function destroyEfsrt($efsrtId)
    {
        // Busca el registro por su ID
        $item = Efsrt::find($efsrtId);
        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }
        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }

    public function disableEfsrtDetalle($efsertDet_id)
    {
        // Busca el registro por su ID
        $item = EfsrtEstudiante::find($efsertDet_id);
        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }
        $item->estado = 0;
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'El convenio fue deshabilitado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue actualizado']);
        }
    }

    public function enableEfsrtDetalle($efsertDet_id)
    {
        // Busca el registro por su ID
        $item = EfsrtEstudiante::find($efsertDet_id);
        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }
        $item->estado = 1;
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'El convenio fue habilitado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue actualizado']);
        }
    }
}
