<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class BackupDatabase extends Command
{
    protected $signature = 'backup:database';
    protected $description = 'Genera un backup de la base de datos y elimina los antiguos después de 7 días';

    public function handle()
    {
        $backupPath = storage_path('app/backups');
        if (!File::exists($backupPath)) {
            File::makeDirectory($backupPath, 0755, true);
        }

        // Generar nuevo backup
        $filename = 'backup-' . now()->format('Y-m-d_H-i-s') . '.sql';
        $fullPath = $backupPath . '/' . $filename;

        $mysqldumpPath = env('MYSQLDUMP_PATH', 'mysqldump');

        $command = sprintf(
            // '"%s" -h%s -u%s -p%s %s > %s',
            '"%s" --no-tablespaces -h%s -u%s -p%s %s > %s',
            $mysqldumpPath,
            escapeshellarg(env('DB_HOST')),
            escapeshellarg(env('DB_USERNAME')),
            escapeshellarg(env('DB_PASSWORD')),
            escapeshellarg(env('DB_DATABASE')),
            escapeshellarg($fullPath)
        );

        exec($command);

        $this->info("Backup creado: {$filename}");

        // Preparar para dejar los 7 backups más recientes
        $maxBackups = 7;

        $backups = collect(File::files($backupPath))
            ->sortByDesc(fn($file) => $file->getMTime())
            ->values();

        if ($backups->count() > $maxBackups) {
            $toDelete = $backups->slice($maxBackups);
            foreach ($toDelete as $file) {
                File::delete($file->getRealPath());
                $this->info("Eliminado backup antiguo: " . $file->getFilename());
            }
        }

        return 0;
    }
}
