<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Boletín Informativo</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            color: #343a40;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        .header {
            text-align: center;
            padding-bottom: 20px;
            border-bottom: 1px solid #e9ecef;
        }
        .header img {
            max-width: 100px;
        }
        .content {
            padding: 20px 0;
        }
        .content h2 {
            color: #007bff;
        }
        .footer {
            text-align: center;
            padding-top: 20px;
            border-top: 1px solid #e9ecef;
            font-size: 12px;
            color: #868e96;
        }
        .btn-primary {
            background-color: #007bff;
            border-color: #007bff;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Encabezado -->
        <div class="header">
            <img src="https://cbp.edu.pe/images/logocatalina.png" alt="Logo de la empresa">
            <h1>Boletín Informativo</h1>
        </div>

        <!-- Contenido Principal -->
        <div class="content">
            <h2>Últimas Noticias</h2>
            <p>Bienvenido a nuestro boletín mensual. Aquí encontrarás las últimas noticias, actualizaciones y eventos más recientes.</p>

            <h3>Título de la Noticia</h3>
            <p>Descripción breve de la noticia o evento importante. <a href="#">Leer más</a></p>

            <img src="https://scontent.flim28-2.fna.fbcdn.net/v/t1.6435-9/139895261_1597913440406612_1604081280351413992_n.jpg?_nc_cat=100&ccb=1-7&_nc_sid=13d280&_nc_ohc=WUWoVmF7h2cQ7kNvgG73AnE&_nc_ht=scontent.flim28-2.fna&oh=00_AYA7Df_5shl6SXob6kuOfgifPXYm9j2VlJsAFOdMJX0lBw&oe=66FEC297" alt="Imagen destacada" class="img-fluid my-4">

            <h3>Otra Noticia Importante</h3>
            <p>Descripción de otra noticia relevante. <a href="#">Leer más</a></p>

            <a href="#" class="btn btn-primary">Visitar nuestro sitio web</a>
        </div>

        <!-- Pie de Página -->
        <div class="footer">
            <p>&copy; 2024 Silfersystem. Todos los derechos reservados.</p>
            <p>
                <a href="#" style="text-decoration: none; color: #007bff;">Darse de baja</a> |
                <a href="#" style="text-decoration: none; color: #007bff;">Política de privacidad</a>
            </p>
        </div>
    </div>
</body>
</html>

