@php use Illuminate\Support\Str; @endphp
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Documentos de Gestión</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet">

    <link rel="stylesheet" href="{{ asset('css/documentos.css') }}">
    <link rel="stylesheet" href="{{ asset('css/admin/transparencia/documentos/documentos.css') }}">
    <link rel="stylesheet" href="{{ asset('css/darkmode.css') }}">
    <link rel="stylesheet" href="{{ asset('css/content.css') }}">
    <meta name="csrf-token" content="{{ csrf_token() }}">
</head>

<body data-titulo="Listado de Documentos de Gestión" class="has-sidebar">
@include('include.preloader')
@include('include.header')
<aside class="sidebar-fixed">@include('include.sidebar')</aside>

<main class="app-content">
    <div class="container-fluid px-3 px-md-4">
        <div class="card roles-card shadow-sm">
            <div class="card-body">

                <div class="d-flex flex-wrap align-items-center justify-content-between gap-2 mb-3">
                    <h5 class="mb-0 fw-bold">Registro de Documentos de Gestión</h5>
                    <div class="d-flex flex-wrap align-items-center gap-2">

                        <div class="btn-toolbar gap-2 me-2">
                            <button class="btn btn-dark btn-pill btn-icon" title="Exportar a Excel" data-export-excel>
                                <i class="fa-regular fa-file-excel me-2"></i> Excel
                            </button>
                            <button class="btn btn-dark btn-pill btn-icon" title="Exportar a PDF" data-export-pdf>
                                <i class="fa-regular fa-file-pdf me-2"></i> PDF
                            </button>
                        </div>

                        <div class="search-wrap position-relative me-2">
                            <i class="fa-solid fa-magnifying-glass search-icon"></i>
                            <input type="text" class="form-control form-control-sm search-input" placeholder="Buscar...">
                        </div>

                        <button class="btn btn-primary btn-pill btn-icon" data-bs-toggle="modal" data-bs-target="#modalNuevo">
                            <i class="fa-solid fa-plus me-2"></i> Nuevo registro
                        </button>
                    </div>
                </div>

                @if (session('success'))
                    <div class="alert alert-success alert-dismissible fade show">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <div class="fw-bold mb-1">Error:</div>
                        <ul class="mb-0">
                            @foreach ($errors->all() as $e)
                                <li>{{ $e }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <div class="table-responsive">
                    <table class="table table-bordered content-table">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>Nombre</th>
                            <th>Descripción</th>
                            <th>Documento</th>
                            <th>Acciones</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($items as $row)
                            <tr>
                                <td>{{ $row->id }}</td>
                                <td class="text-muted fw-semibold">{{ $row->nombre }}</td>
                                <td class="text-muted">{{ $row->descripcion }}</td>
                                <td class="text-center">
                                    @if ($row->documento)
                                        <button type="button" class="btn btn-light pdf-open"
                                                data-url="{{ asset($row->documento) }}">
                                            <span class="pdf-thumb">
                                                <i class="fa-solid fa-file-pdf"></i>
                                            </span>
                                        </button>
                                    @else
                                        <span class="text-muted">—</span>
                                    @endif
                                </td>
                                <td class="text-center">
                                    <div class="d-inline-flex gap-1">
                                        <button class="btn btn-warning btn-sm text-white btn-edit"
                                                title="Editar"
                                                data-id="{{ $row->id }}"
                                                data-nombre="{{ $row->nombre }}"
                                                data-descripcion="{{ $row->descripcion }}"
                                                data-active="{{ (int) $row->is_active }}">
                                            <i class="fa-regular fa-pen-to-square"></i>
                                        </button>

                                        <button class="btn btn-danger btn-sm btn-delete"
                                                title="Eliminar"
                                                data-bs-toggle="modal"
                                                data-bs-target="#modalEliminar"
                                                data-delete-url="{{ route('documentos.destroy', ['documento' => $row->id]) }}"
                                                data-title="{{ $row->nombre }}">
                                            <i class="fa-regular fa-trash-can"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center text-muted">Sin registros.</td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>

    {{-- Modal: Nuevo --}}
    <div class="modal fade" id="modalNuevo" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <form action="{{ route('documentos.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title" style="color:#2563eb;">Nuevo documento</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label" style="color:#2563eb;">Nombre *</label>
                            <input type="text" name="nombre" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label" style="color:#2563eb;">Descripción *</label>
                            <textarea name="descripcion" rows="3" class="form-control" required></textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label" style="color:#2563eb;">PDF *</label>
                            <input type="file" name="documento" class="form-control" accept="application/pdf" required>
                            <small class="text-muted">Solo PDF. Máx. 20MB.</small>
                        </div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="createActive" name="is_active" value="1" checked>
                            <label class="form-check-label" for="createActive" style="color:#2563eb;">Activo</label>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Guardar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- Modal: Editar --}}
    <div class="modal fade" id="modalEditar" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                {{-- Importante: submit nativo (POST + _method=PUT) --}}
                <form id="formEditar" action="#" method="POST" enctype="multipart/form-data">
                    @csrf @method('PUT')
                    <div class="modal-header">
                        <h5 class="modal-title" style="color:#2563eb;">Editar documento</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label" style="color:#2563eb;">Nombre *</label>
                            <input type="text" id="editNombre" name="nombre" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label" style="color:#2563eb;">Descripción *</label>
                            <textarea id="editDescripcion" name="descripcion" rows="3" class="form-control" required></textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label" style="color:#2563eb;">Reemplazar PDF</label>
                            <input type="file" name="documento" class="form-control" accept="application/pdf">
                            <small class="text-muted">Deja vacío si no deseas reemplazar el archivo.</small>
                        </div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" id="editActive" name="is_active" value="1">
                            <label class="form-check-label" for="editActive" style="color:#2563eb;">Activo</label>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary">Guardar cambios</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- Modal: Vista previa PDF --}}
    <div class="modal fade" id="pdfModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title" style="color:#2563eb;">Vista previa del documento</h6>
                    <a id="pdfNewTab" href="#" target="_blank" class="btn btn-outline-primary btn-sm">
                        <i class="fa-solid fa-up-right-from-square me-1"></i> Abrir en pestaña nueva
                    </a>
                    <button class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body p-0">
                    <iframe id="pdfFrame" src="" style="width:100%;height:80vh;border:0;"></iframe>
                </div>
            </div>
        </div>
    </div>

    {{-- Modal: Eliminar --}}
    <div class="modal fade" id="modalEliminar" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                {{-- Usaremos POST + _method=DELETE desde JS (robusto en hosting) --}}
                <form id="formEliminar" action="#" method="POST">
                    @csrf
                    <div class="modal-header">
                        <h5 class="modal-title" style="color:#2563eb;">Eliminar</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body" style="color:#2563eb;">
                        ¿Seguro que deseas eliminar <strong id="delTitulo">este documento</strong>?
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-danger">Sí, eliminar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</main>

@include('include.footer')

{{-- Exponer rutas para JS --}}
<script>
  window.DOC_ROUTES = {
    update: "{{ route('documentos.update', ['documento' => '__ID__']) }}",
    destroy: "{{ route('documentos.destroy', ['documento' => '__ID__']) }}"
  };
  window.CSRF_TOKEN = "{{ csrf_token() }}";
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

{{-- cache-buster --}}
<script src="{{ asset('js/admin/transparencia/documentos/documentos_gestion.js') }}?v={{ time() }}" type="module"></script>

<script src="{{ asset('js/search.js') }}"></script>
<script src="{{ asset('js/exportarPDF.js') }}"></script>
<script src="{{ asset('js/exportarEXCEL.js') }}"></script>
<script src="{{ asset('js/admin/darkmode.js') }}"></script>

</body>
</html>
