// Inicializa iconos cuando el DOM est listo
document.addEventListener('DOMContentLoaded', () => {
    if (window.lucide) window.lucide.createIcons();
    updateActiveNavigation();
});

const yearEl = document.getElementById('year');
if (yearEl) yearEl.textContent = new Date().getFullYear();

let activeSection = 'hero';

// ---- Navegacin lateral: marcar seccin activa
function updateActiveNavigation() {
    const sections = document.querySelectorAll('main section[id]');
    let current = 'hero';
    sections.forEach(section => {
        const rectTop = section.getBoundingClientRect().top + window.scrollY;
        const h = section.offsetHeight;
        if (window.scrollY >= rectTop - 200 && window.scrollY < rectTop + h - 200) {
            current = section.id;
        }
    });
    if (current !== activeSection) {
        const prev = document.querySelector(`[data-section="${activeSection}"]`);
        if (prev) {
            prev.classList.remove('bg-[#E27227]');
            prev.classList.add('hover:bg-[#1A4FD3]/20');
        }
        const now = document.querySelector(`[data-section="${current}"]`);
        if (now) {
            now.classList.add('bg-[#E27227]');
            now.classList.remove('hover:bg-[#1A4FD3]/20');
        }
        activeSection = current;
    }
}

window.addEventListener('scroll', updateActiveNavigation);
window.addEventListener('load', updateActiveNavigation);

// ---- Helper: scroll a seccin
function scrollToSection(id) {
    const el = document.getElementById(id);
    if (!el) return;
    const y = el.getBoundingClientRect().top + window.pageYOffset - 80;
    window.scrollTo({ top: y, behavior: 'smooth' });
}
window.scrollToSection = scrollToSection;

// =====================
//  Modal Visor de PDF
// =====================
const modalEl  = document.getElementById('pdfModal');
const frameEl  = document.getElementById('pdfFrame');
const linkEl   = document.getElementById('openPdfNewTab');

// Abre modal con URL de PDF
function openPdfModal(url) {
    if (!modalEl || !frameEl || !linkEl) return;
    frameEl.src = url;      // carga el PDF en el iframe
    linkEl.href = url;      // link para nueva pestaa
    modalEl.classList.remove('hidden');
    document.body.style.overflow = 'hidden'; // bloquea scroll fondo
}
window.openPdfModal = openPdfModal;

// Cierra modal y limpia iframe
function closePdfModal() {
    if (!modalEl || !frameEl) return;
    frameEl.src = ''; // liberar recurso
    modalEl.classList.add('hidden');
    document.body.style.overflow = ''; // restaura scroll
}
window.closePdfModal = closePdfModal;

// Cerrar con ESC
document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape' && !modalEl.classList.contains('hidden')) {
        closePdfModal();
    }
});

// Cerrar al hacer click fuera del cuadro
modalEl?.addEventListener('click', (e) => {
    const content = modalEl.querySelector('div.bg-white');
    if (content && !content.contains(e.target)) {
        closePdfModal();
    }
});

// =====================
//  (Opcionales)
// =====================
function filterDocuments(filter) {
    document.querySelectorAll('.document-card').forEach(card => {
        const cat = card.getAttribute('data-cat');
        card.style.display = (filter === 'all' || filter === cat) ? 'block' : 'none';
    });
}

function searchDocuments() {
    const term = (document.getElementById('searchInput')?.value || '').toLowerCase().trim();
    document.querySelectorAll('.document-card').forEach(card => {
        const name = (card.getAttribute('data-name') || '').toLowerCase();
        const desc = (card.getAttribute('data-desc') || '').toLowerCase();
        card.style.display = (name.includes(term) || desc.includes(term)) ? 'block' : 'none';
    });
}
