// public/js/admin/transparencia/tupa/tupa.js
document.addEventListener('DOMContentLoaded', () => {
    /* ========== ACTUALIZAR DOCUMENTO ========== */
    const btnUpdateDoc = document.getElementById('btnUpdateDocumento');
    const inputDoc = document.getElementById('tupaDocumento');
    const alertContainer = document.getElementById('tupaAlerts');

    function showAlert(type, message) {
      if (!alertContainer) return;
      alertContainer.innerHTML = `
        <div class="alert alert-${type} alert-dismissible fade show mt-2" role="alert">
          ${message}
          <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
      `;
      alertContainer.scrollIntoView({ behavior: 'smooth', block: 'center' });
    }

    if (btnUpdateDoc && inputDoc) {
      btnUpdateDoc.addEventListener('click', async () => {
        const file = inputDoc.files[0];

        if (!file) {
          showAlert('warning', 'Por favor selecciona un documento antes de actualizar.');
          return;
        }

        const urlUpdateDoc = btnUpdateDoc.getAttribute('data-updateDocument-url');
        const formData = new FormData();
        formData.append('documento', file);
        formData.append('_token', document.querySelector('meta[name="csrf-token"]')?.content || '');

        btnUpdateDoc.disabled = true;
        btnUpdateDoc.innerHTML = '<i class="fa-solid fa-spinner fa-spin me-2"></i> Actualizando...';

        try {
          const response = await fetch(urlUpdateDoc, {
            method: "POST",
            body: formData
          });

        const data = await response.json().catch(() => ({}));

          if (!response.ok) {
            const msg = data.message || 'Error al actualizar el documento.';
            throw new Error(msg);
          }

        showAlert('success', data.message || 'Documento actualizado correctamente.');

          // Si deseas recargar después de 2s para mostrar el nuevo documento
          setTimeout(() => location.reload(), 2000);

        } catch (err) {
          console.error(err);
          showAlert('danger', err.message || 'Hubo un problema al subir el documento.');
        } finally {
          btnUpdateDoc.disabled = false;
          btnUpdateDoc.innerHTML = '<i class="fa-solid fa-rotate me-2"></i> Actualizar';
        }
      });
    }

  /* ========== EDITAR ========== */
  const editModalEl = document.getElementById('modalEditar');
  const editModal   = editModalEl ? new bootstrap.Modal(editModalEl) : null;

  const formEdit  = document.getElementById('formEditar');
  const eConcepto = document.getElementById('editConcepto');
  const eMonto    = document.getElementById('editMonto');
  const eActive   = document.getElementById('editActive');

  document.querySelectorAll('.btn-edit').forEach(btn => {
    btn.addEventListener('click', () => {
      const id  = btn.dataset.id;
      const tpl = formEdit?.dataset.actionTemplate || ''; // ej: route('tupa.update', ['tupa' => '__ID__'])

      if (!tpl) {
        console.error('Falta data-action-template en #formEditar');
        return;
      }

      if (eConcepto) eConcepto.value = btn.dataset.concepto || '';
      if (eMonto)    eMonto.value    = btn.dataset.monto || 0;
      if (eActive)   eActive.checked = parseInt(btn.dataset.active, 10) === 1;

      // URL PUT final (sin hardcodear prefijo)
      formEdit.action = tpl.replace('__ID__', id);

      if (editModal) editModal.show();
    });
  });

  /* ========== ELIMINAR ========== */
  const formDelete = document.getElementById('formEliminar');
  const delTitulo  = document.getElementById('delTitulo');

  document.addEventListener('click', (e) => {
    const btn = e.target.closest('.btn-delete');
    if (!btn) return;

    const url   = btn.getAttribute('data-delete-url'); // viene de route('tupa.destroy', $row)
    const title = btn.getAttribute('data-title') || 'este registro';

    if (!url) {
      console.error('btn-delete sin data-delete-url');
      return;
    }

    if (formDelete) formDelete.setAttribute('action', url);
    if (delTitulo)  delTitulo.textContent = title;
  });

  // (Opcional) limpiar acción al cerrar modal de eliminar
  const modalEliminar = document.getElementById('modalEliminar');
  if (modalEliminar && formDelete) {
    modalEliminar.addEventListener('hidden.bs.modal', () => {
      formDelete.setAttribute('action', '#');
    });
  }

  /* ========== PAGINACIÓN SIMPLE ========== */
  const tableBody = document.querySelector('.content-table tbody');
  if (tableBody) {
    const rows = Array.from(tableBody.querySelectorAll('tr'));
    const dataRows = rows.filter(r => !r.classList.contains('no-data') && r.children.length > 2);
    const pageSize = 5;
    let currentPage = 1;
    const totalPages = Math.ceil(Math.max(dataRows.length, 1) / pageSize);

    function renderPage(page) {
      tableBody.innerHTML = '';
      const start = (page - 1) * pageSize;
      const end   = start + pageSize;
      const pageRows = dataRows.slice(start, end);
      pageRows.forEach(r => tableBody.appendChild(r));
      if (pageRows.length === 0) {
        const tr = document.createElement('tr');
        tr.innerHTML = '<td colspan="4" class="text-center text-muted">Sin registros.</td>';
        tableBody.appendChild(tr);
      }
    }

    function createPagination() {
      const table = tableBody.closest('table');
      const host  = table ? table.parentElement : tableBody.parentElement;

      host.querySelectorAll('.tupa-pagination').forEach(p => p.remove());

      const nav = document.createElement('nav');
      nav.className = 'tupa-pagination mt-3';
      const prevDisabled = currentPage === 1 ? ' disabled' : '';
      const nextDisabled = currentPage === totalPages ? ' disabled' : '';

      nav.innerHTML = `<ul class="pagination justify-content-end">
        <li class="page-item${prevDisabled}">
          <a class="page-link" href="#" aria-label="Anterior"><span aria-hidden="true">&laquo;</span></a>
        </li>
        ${Array.from({ length: totalPages }, (_, i) =>
          `<li class="page-item${i + 1 === currentPage ? ' active' : ''}">
             <a class="page-link" href="#">${i + 1}</a>
           </li>`
        ).join('')}
        <li class="page-item${nextDisabled}">
          <a class="page-link" href="#" aria-label="Siguiente"><span aria-hidden="true">&raquo;</span></a>
        </li>
      </ul>`;

      host.appendChild(nav);

      const links = nav.querySelectorAll('.page-link');

      // « anterior
      links[0].addEventListener('click', e => {
        e.preventDefault();
        if (currentPage > 1) {
          currentPage--;
          renderPage(currentPage);
          createPagination();
        }
      });

      // números
      links.forEach((a, idx) => {
        if (idx > 0 && idx < totalPages + 1) {
          a.addEventListener('click', e => {
            e.preventDefault();
            currentPage = idx;
            renderPage(currentPage);
            createPagination();
          });
        }
      });

      // » siguiente
      links[totalPages + 1].addEventListener('click', e => {
        e.preventDefault();
        if (currentPage < totalPages) {
          currentPage++;
          renderPage(currentPage);
          createPagination();
        }
      });
    }

    renderPage(currentPage);
    if (totalPages > 1) createPagination();
  }

  /* Reabrir modal NUEVO si hubo errores server-side */
  if (window.tupaShowNuevoModal) {
    const nuevo = document.getElementById('modalNuevo');
    if (nuevo) new bootstrap.Modal(nuevo).show();
  }
});