// public/js/admin/transparencia/licenciamiento/licenciamiento.js
document.addEventListener('DOMContentLoaded', () => {
  /* ===============================
   *  MODALES / ELEMENTOS
   * =============================== */
  // Editar
  const modalEditEl = document.getElementById('modalEditar');
  const modalEdit   = modalEditEl ? new bootstrap.Modal(modalEditEl) : null;
  const formEdit    = document.getElementById('formEditar');
  const eNombre     = document.getElementById('eNombre');
  const eDesc       = document.getElementById('eDescripcion');
  const eActivo     = document.getElementById('eActivo');

  // Eliminar
  const modalDelEl  = document.getElementById('modalEliminar');
  const modalDel    = modalDelEl ? new bootstrap.Modal(modalDelEl) : null;
  const formDel     = document.getElementById('formEliminar');
  const delTitle    = document.getElementById('delTitulo');

  // PDF
  const modalPdfEl  = document.getElementById('modalPdf');
  const modalPdf    = modalPdfEl ? new bootstrap.Modal(modalPdfEl) : null;
  const pdfFrame    = document.getElementById('pdfFrame');
  const openPdfNew  = document.getElementById('openPdfNewTab');

  /* ===============================
   *  LIMPIEZA AL CERRAR PDF
   * =============================== */
  if (modalPdfEl) {
    modalPdfEl.addEventListener('hidden.bs.modal', () => {
      if (pdfFrame)  pdfFrame.src = '';
      if (openPdfNew) openPdfNew.removeAttribute('href');
    });
  }

  /* ===============================
   *  EVENT DELEGATION
   * =============================== */
  document.addEventListener('click', (e) => {
    // 1) Abrir PDF: elemento con .pdf-thumb y data-src
    const pdfBtn = e.target.closest('.pdf-thumb');
    if (pdfBtn) {
      if (pdfBtn.classList.contains('disabled')) return;
      const url = pdfBtn.getAttribute('data-src');
      if (!url) return;
      if (pdfFrame)  pdfFrame.src = url;
      if (openPdfNew) openPdfNew.href = url;
      modalPdf && modalPdf.show();
      return;
    }

    // 2) Editar
    const editBtn = e.target.closest('.btn-edit');
    if (editBtn) {
      const id = editBtn.getAttribute('data-id');
      if (eNombre) eNombre.value  = editBtn.getAttribute('data-nombre') || '';
      if (eDesc)   eDesc.value    = editBtn.getAttribute('data-descripcion') || '';
      if (eActivo) eActivo.checked = (editBtn.getAttribute('data-active') === '1');

      if (formEdit) formEdit.action = `/admin/transparencia/licenciamiento/${id}`;
      modalEdit && modalEdit.show();
      return;
    }

    // 3) Eliminar
    const delBtn = e.target.closest('.btn-delete');
    if (delBtn) {
      const url   = delBtn.getAttribute('data-url') || '#';
      const title = delBtn.getAttribute('data-title') || 'este registro';
      if (formDel)   formDel.setAttribute('action', url);
      if (delTitle)  delTitle.textContent = title;
      modalDel && modalDel.show();
      return;
    }
  });
});
