document.addEventListener('DOMContentLoaded', () => {
  const modalEdit  = new bootstrap.Modal(document.getElementById('modalEditar'));
  const formEdit   = document.getElementById('formEditar');
  const eServicio  = document.getElementById('eServicio');
  const eLV        = document.getElementById('eLV');
  const eSab       = document.getElementById('eSab');
  const eDom       = document.getElementById('eDom');
  const eContacto  = document.getElementById('eContacto');
  const eActivo    = document.getElementById('eActivo');

  document.querySelectorAll('.btn-edit').forEach(btn => {
    btn.addEventListener('click', () => {
      const id = btn.dataset.id;

      eServicio.value = btn.dataset.servicio;
      eLV.value       = btn.dataset.lv || '';
      eSab.value      = btn.dataset.sab || '';
      eDom.value      = btn.dataset.dom || '';
      eContacto.value = btn.dataset.contacto || '';
      eActivo.checked = parseInt(btn.dataset.active, 10) === 1;

      // ✅ construir la URL correcta desde el template de Blade
      const tpl = formEdit.dataset.updateTemplate || '';
      formEdit.action = tpl.replace('__ID__', id);

      modalEdit.show();
    });
  });

  // eliminar (ya usas data-delete-url generado con route(), está OK)
  document.addEventListener('click', (e) => {
    const btn = e.target.closest('.btn-delete');
    if (!btn) return;
    const form = document.getElementById('formEliminar');
    if (!form) return;
    form.action = btn.dataset.deleteUrl;
    const delTitle = document.getElementById('delTitulo');
    if (delTitle) delTitle.textContent = btn.dataset.title || 'este registro';
  });
});
