// public/js/admin/programas_estudios/gestionar_programas/gestionar_programa.js

document.addEventListener('DOMContentLoaded', () => {
  // ====== Config base URL desde el Blade (sin Blade dentro del .js) ======
  const BASE = document.body.dataset.programasBaseUrl || '';
  if (!BASE) {
    console.warn('No se encontró data-programas-base-url en <body>.');
  }

  // ====== Bootstrap.Modal helpers con elementos ======
  const modalImagenEl  = document.getElementById('modalImagen');
  const modalEditarEl  = document.getElementById('modalEditar');
  const modalEliminarEl= document.getElementById('modalEliminar');

  const imgModal  = modalImagenEl  ? new bootstrap.Modal(modalImagenEl)   : null;
  const editModal = modalEditarEl  ? new bootstrap.Modal(modalEditarEl)   : null;
  const delModal  = modalEliminarEl? new bootstrap.Modal(modalEliminarEl) : null;

  // ====== Ver imagen ======
  const vistaImg  = document.getElementById('vistaImg');
  const tituloImg = document.getElementById('tituloImg');

  document.querySelectorAll('.btn-show-img').forEach(b => {
    b.addEventListener('click', () => {
      if (!imgModal) return;
      if (vistaImg)  vistaImg.src = b.dataset.img || '';
      if (tituloImg) tituloImg.textContent = 'Imagen — ' + (b.dataset.nombre || '');
      imgModal.show();
    });
  });

  // ====== Editar ======
  const formEdit  = document.getElementById('formEditar');
  const eNombre   = document.getElementById('eNombre');
  const eDesc     = document.getElementById('eDescripcion');
  const ePrev     = document.getElementById('ePreview');
  const eActivo   = document.getElementById('eActivo');

  document.querySelectorAll('.btn-edit').forEach(b => {
    b.addEventListener('click', () => {
      if (!editModal || !formEdit) return;

      const id = b.dataset.id;
      if (!id) return;

      if (eNombre) eNombre.value = b.dataset.nombre || '';
      if (eDesc)   eDesc.value   = b.dataset.descripcion || '';
      if (ePrev)   ePrev.src     = b.dataset.img || '';
      if (eActivo) eActivo.checked = true; // si luego quieres pasar el flag real, añade data-active al botón

      // Setea la acción con la base URL correcta
      formEdit.action = `${BASE}/${encodeURIComponent(id)}`;

      editModal.show();
    });
  });

  // ====== Eliminar ======
  const formDel  = document.getElementById('formEliminar');
  const delName  = document.getElementById('delNombre');

  document.querySelectorAll('.btn-delete').forEach(b => {
    b.addEventListener('click', () => {
      if (!delModal || !formDel) return;

      const id = b.dataset.id;
      if (!id) return;

      if (delName) delName.textContent = b.dataset.nombre || '';

      // Setea la acción con la base URL correcta
      formDel.action = `${BASE}/${encodeURIComponent(id)}`;

      delModal.show();
    });
  });

  // ====== Paginación tabla programas (sin tocar HTML) ======
  const tableBody = document.querySelector('.programa-table tbody');
  if (tableBody) {
    const rows = Array.from(tableBody.querySelectorAll('tr'));
    const dataRows = rows.filter(row => !row.classList.contains('no-data') && row.children.length > 3);
    const pageSize = 5;
    let currentPage = 1;
    const totalPages = Math.ceil(dataRows.length / pageSize) || 1;

    function renderPage(page) {
      tableBody.innerHTML = '';
      const start = (page - 1) * pageSize;
      const end = start + pageSize;
      const pageRows = dataRows.slice(start, end);
      pageRows.forEach(row => tableBody.appendChild(row));
      if (pageRows.length === 0) {
        const noDataRow = document.createElement('tr');
        noDataRow.innerHTML = '<td colspan="5" class="text-center text-muted">Sin registros.</td>';
        tableBody.appendChild(noDataRow);
      }
    }

    function createPagination() {
      let pagination = document.querySelector('.programa-pagination');
      if (pagination) pagination.remove();

      pagination = document.createElement('nav');
      pagination.className = 'programa-pagination mt-3';

      const html =
        '<ul class="pagination justify-content-end">' +
        `<li class="page-item${currentPage === 1 ? ' disabled' : ''}">
          <a class="page-link" href="#" data-nav="prev" aria-label="Anterior"><span aria-hidden="true">&laquo;</span></a>
        </li>` +
        Array.from({ length: totalPages }, (_, i) => {
          const n = i + 1;
          return `<li class="page-item${n === currentPage ? ' active' : ''}">
            <a class="page-link" href="#" data-page="${n}">${n}</a>
          </li>`;
        }).join('') +
        `<li class="page-item${currentPage === totalPages ? ' disabled' : ''}">
          <a class="page-link" href="#" data-nav="next" aria-label="Siguiente"><span aria-hidden="true">&raquo;</span></a>
        </li>` +
        '</ul>';

      pagination.innerHTML = html;

      const table = tableBody.closest('table');
      const container = table ? table.parentElement : tableBody.parentElement;

      const prevPaginations = container.querySelectorAll('.programa-pagination');
      prevPaginations.forEach(p => p.remove());
      container.appendChild(pagination);

      pagination.addEventListener('click', (e) => {
        const a = e.target.closest('a.page-link');
        if (!a) return;
        e.preventDefault();

        if (a.dataset.nav === 'prev' && currentPage > 1) currentPage--;
        else if (a.dataset.nav === 'next' && currentPage < totalPages) currentPage++;
        else if (a.dataset.page) currentPage = parseInt(a.dataset.page, 10);

        renderPage(currentPage);
        createPagination();
      });
    }

    renderPage(currentPage);
    if (totalPages > 1) createPagination();
  }
});
