// public/js/admin/inicio/slider/slider.js
document.addEventListener('DOMContentLoaded', () => {
  const baseUrl = document.body.dataset.sliderBaseUrl; // /admin/slider
  const btnNuevo = document.getElementById('btnNuevo');

  // MODALES
  const mNuevo = new bootstrap.Modal(document.getElementById('modalNuevo'));
  const mEditar = new bootstrap.Modal(document.getElementById('modalEditar'));
  const mEliminar = new bootstrap.Modal(document.getElementById('modalEliminar'));
  const mImagen = new bootstrap.Modal(document.getElementById('modalImagen'));

  // FORMULARIOS
  const fEditar = document.getElementById('formEditar');
  const fEliminar = document.getElementById('formEliminar');

  // PREVIEW EN EDITAR
  const ePreview = document.getElementById('ePreview');
  const eImagen  = document.getElementById('eImagen');
  eImagen?.addEventListener('change', (e) => {
    const file = e.target.files?.[0];
    if (file) ePreview.src = URL.createObjectURL(file);
  });

  // NUEVO
  btnNuevo?.addEventListener('click', () => mNuevo.show());

  // EDITAR
  document.querySelectorAll('.btn-edit').forEach(btn => {
    btn.addEventListener('click', () => {
      const id = btn.dataset.id;
      const active = btn.dataset.active === '1';
      const img = btn.dataset.img;

      fEditar.action = `${baseUrl}/${id}`;
      ePreview.src = img || '/images/no-photo.jpg';
      document.getElementById('eActivo').checked = active;
      eImagen.value = '';
      mEditar.show();
    });
  });

  // ELIMINAR
  document.querySelectorAll('.btn-delete').forEach(btn => {
    btn.addEventListener('click', () => {
      const id = btn.dataset.id;
      fEliminar.action = `${baseUrl}/${id}`;
      document.getElementById('delId').textContent = `#${id}`;
      mEliminar.show();
    });
  });

  // VER IMAGEN
  const vistaImg = document.getElementById('vistaImg');
  const tituloImg = document.getElementById('tituloImg');
  document.querySelectorAll('.btn-show-img').forEach(btn => {
    btn.addEventListener('click', () => {
      vistaImg.src = btn.dataset.img;
      tituloImg.textContent = btn.dataset.nombre || 'Imagen';
      mImagen.show();
    });
  });

  // BUSCAR EN TABLA (cliente)
  const search = document.querySelector('[data-filter-table]');
  const rows = Array.from(document.querySelectorAll('#sliderTable tbody tr'));
  search?.addEventListener('input', () => {
    const q = (search.value || '').toLowerCase();
    rows.forEach(tr => {
      const text = tr.innerText.toLowerCase();
      tr.style.display = text.includes(q) ? '' : 'none';
    });
  });
});
