document.addEventListener('DOMContentLoaded', () => {
  // --- Rutas desde inputs ocultos ---
  const updateTplEl = document.getElementById('beneficioUpdateRoute');
  const deleteTplEl = document.getElementById('beneficioDeleteRoute');
  const updateTpl = updateTplEl ? updateTplEl.value : '';
  const deleteTpl = deleteTplEl ? deleteTplEl.value : '';

  if (!updateTpl || !deleteTpl) {
    console.error('Faltan los inputs ocultos de rutas: #beneficioUpdateRoute y/o #beneficioDeleteRoute');
  }

  // ------- Preview cono en "Nuevo" -------
  const iconCreate = document.getElementById('iconCreate');
  const iconCreatePreview = document.getElementById('iconCreatePreview');
  if (iconCreate) {
    iconCreate.addEventListener('change', () => {
      const cls = iconCreate.value || '';
      iconCreatePreview.innerHTML = cls ? `<i class="${cls}"></i>` : '';
    });
  }

  // -------- Editar ----------
  const modalEdit = new window.bootstrap.Modal(document.getElementById('modalEditarBeneficio'));
  const formEdit = document.getElementById('formEditarBeneficio');
  const eNombre = document.getElementById('editNombre');
  const eDesc = document.getElementById('editDescripcion');
  const eIconSel = document.getElementById('iconEdit');
  const eIconPrev = document.getElementById('iconEditPreview');
  const eActive = document.getElementById('editActive');

  if (eIconSel) {
    eIconSel.addEventListener('change', () => {
      const cls = eIconSel.value || '';
      eIconPrev.innerHTML = cls ? `<i class="${cls}"></i>` : '';
    });
  }

  document.querySelectorAll('.btn-edit-beneficio').forEach(btn => {
    btn.addEventListener('click', () => {
      const id  = btn.dataset.id;
      const nom = btn.dataset.nombre || '';
      const des = btn.dataset.descripcion || '';
      const ico = btn.dataset.icono || '';
      const act = btn.dataset.active === '1';

      // Completar formulario
      eNombre.value = nom;
      eDesc.value = des;
      if (eIconSel) {
        [...eIconSel.options].forEach(o => { o.selected = (o.value === ico); });
      }
      eIconPrev.innerHTML = ico ? `<i class="${ico}"></i>` : '';
      eActive.checked = act;

      // Accin PUT por ID (usa plantilla desde input oculto)
      if (updateTpl) {
        formEdit.action = updateTpl.replace('__ID__', id);
      } else {
        console.error('No se pudo asignar action del form de edicin: updateTpl vaco');
      }

      modalEdit.show();
    });
  });

  // -------- Eliminar ----------
  const modalDel = new window.bootstrap.Modal(document.getElementById('modalEliminarBeneficio'));
  const formDel = document.getElementById('formEliminarBeneficio');
  const delName = document.getElementById('delBeneficioNombre');

  document.querySelectorAll('.btn-delete-beneficio').forEach(btn => {
    btn.addEventListener('click', () => {
      const id   = btn.dataset.id;
      const name = btn.dataset.nombre || '';
      delName.textContent = name;

      // Accin DELETE por ID (usa plantilla desde input oculto)
      if (deleteTpl) {
        formDel.action = deleteTpl.replace('__ID__', id);
      } else {
        console.error('No se pudo asignar action del form de eliminacin: deleteTpl vaco');
      }

      modalDel.show();
    });
  });

  // -------- Reabrir modal "Nuevo" si fall validacin en create --------
  const showNuevo = document.body.dataset.showNuevo === '1';
  if (showNuevo) {
    new window.bootstrap.Modal(document.getElementById('modalNuevoBeneficio')).show();
  }

  // -------- Paginacin tabla beneficios ----------
  const tableBody = document.querySelector('.beneficios-table tbody');
  if (tableBody) {
    const rows = Array.from(tableBody.querySelectorAll('tr'));
    const dataRows = rows.filter(row => !row.classList.contains('no-data') && row.children.length === 5);
    const pageSize = 5;
    let currentPage = 1;
    const totalPages = Math.ceil(dataRows.length / pageSize);

    function renderPage(page) {
      tableBody.innerHTML = '';
      const start = (page - 1) * pageSize;
      const end   = start + pageSize;
      const pageRows = dataRows.slice(start, end);
      pageRows.forEach(row => tableBody.appendChild(row));
      if (pageRows.length === 0) {
        const noDataRow = document.createElement('tr');
        noDataRow.innerHTML = '<td colspan="5" class="text-center text-muted">Sin registros.</td>';
        tableBody.appendChild(noDataRow);
      }
    }

    function createPagination() {
      let pagination = document.querySelector('.beneficios-pagination');
      if (pagination) pagination.remove();

      pagination = document.createElement('nav');
      pagination.className = 'beneficios-pagination mt-3';

      const prevDisabled = currentPage === 1 ? ' disabled' : '';
      const nextDisabled = currentPage === totalPages ? ' disabled' : '';

      pagination.innerHTML = `<ul class="pagination justify-content-end">
        <li class="page-item${prevDisabled}">
          <a class="page-link" href="#" aria-label="Anterior"><span aria-hidden="true">&laquo;</span></a>
        </li>
        ${Array.from({ length: totalPages }, (_, i) =>
          `<li class="page-item${i + 1 === currentPage ? ' active' : ''}">
            <a class="page-link" href="#">${i + 1}</a>
          </li>`
        ).join('')}
        <li class="page-item${nextDisabled}">
          <a class="page-link" href="#" aria-label="Siguiente"><span aria-hidden="true">&raquo;</span></a>
        </li>
      </ul>`;

      const table = tableBody.closest('table');
      if (table) {
        const prevPaginations = table.parentElement.querySelectorAll('.beneficios-pagination');
        prevPaginations.forEach(p => p.remove());
        table.parentElement.appendChild(pagination);
      } else {
        tableBody.parentElement.appendChild(pagination);
      }

      const pageLinks = pagination.querySelectorAll('.page-link');

      // Anterior
      if (pageLinks[0]) {
        pageLinks[0].addEventListener('click', (e) => {
          e.preventDefault();
          if (currentPage > 1) {
            currentPage--;
            renderPage(currentPage);
            createPagination();
          }
        });
      }

      // Nmeros
      for (let i = 1; i <= totalPages; i++) {
        const link = pageLinks[i];
        if (!link) continue;
        link.addEventListener('click', (e) => {
          e.preventDefault();
          currentPage = i;
          renderPage(currentPage);
          createPagination();
        });
      }

      // Siguiente
      const nextLink = pageLinks[pageLinks.length - 1];
      if (nextLink) {
        nextLink.addEventListener('click', (e) => {
          e.preventDefault();
          if (currentPage < totalPages) {
            currentPage++;
            renderPage(currentPage);
            createPagination();
          }
        });
      }
    }

    renderPage(currentPage);
    if (totalPages > 1) createPagination();
  }
});
