// public/js/admin/admision_matricula/beca/tipo/beca-tipo.js
document.addEventListener('DOMContentLoaded', () => {
  // ====== Editar ======
  const editModalEl = document.getElementById('modalEditar');
  const editModal = editModalEl ? new bootstrap.Modal(editModalEl) : null;

  const formEdit = document.getElementById('formEditar');
  const editNombre = document.getElementById('editNombre');
  const eActive = document.getElementById('editActive');

  document.querySelectorAll('.btn-edit').forEach(btn => {
    btn.addEventListener('click', () => {
      const id   = btn.dataset.id;
      const tpl  = formEdit?.dataset.actionTemplate || '';
      const url   = btn.getAttribute('data-update-url') || '';

      if (!url) {
        console.error('El botón de actualizar no tiene data-update-url con la ruta UPDATE.');
        return;
      }

      if (editNombre) editNombre.value = btn.dataset.nombre || '';
      if (eActive) eActive.checked = parseInt(btn.dataset.active, 10) == 1;

      if (formEdit) formEdit.action = url;
      if (editModal) editModal.show();
    });
  });

  // ====== Eliminar ======
  const formDelete = document.getElementById('formEliminar');
  const delPeriodo  = document.getElementById('delPeriodo');

  document.addEventListener('click', (e) => {
    const btn = e.target.closest('.btn-delete');
    if (!btn) return;

    const url   = btn.getAttribute('data-url') || '';
    const title = btn.getAttribute('data-title') || 'este registro';

    if (!url) {
      console.error('El botón de eliminar no tiene data-url con la ruta DELETE.');
      return;
    }

    if (formDelete) formDelete.setAttribute('action', url);
    if (delPeriodo)  delPeriodo.textContent = title;
  });

  // ====== Paginación simple ======
  let tableBody = document.querySelector('.beca-tipo-table tbody');
  if (!tableBody) tableBody = document.querySelector('.content-table tbody');

  if (tableBody) {
    const rows = Array.from(tableBody.querySelectorAll('tr'));
    const dataRows = rows.filter(r => !r.classList.contains('no-data') && r.children.length > 3);
    const pageSize = 5;
    let currentPage = 1;
    const totalPages = Math.ceil(Math.max(dataRows.length, 1) / pageSize);

    function renderPage(page) {
      tableBody.innerHTML = '';
      const start = (page - 1) * pageSize;
      const end   = start + pageSize;
      const pageRows = dataRows.slice(start, end);
      pageRows.forEach(r => tableBody.appendChild(r));
      if (pageRows.length === 0) {
        const tr = document.createElement('tr');
        tr.innerHTML = '<td colspan="7" class="text-center text-muted">Sin registros.</td>';
        tableBody.appendChild(tr);
      }
    }

    function createPagination() {
      const table = tableBody.closest('table');
      const host  = table ? table.parentElement : tableBody.parentElement;

      host.querySelectorAll('.beca-tipo-pagination').forEach(p => p.remove());

      const nav = document.createElement('nav');
      nav.className = 'beca-tipo-pagination mt-3';

      const prevDisabled = currentPage === 1 ? ' disabled' : '';
      const nextDisabled = currentPage === totalPages ? ' disabled' : '';

      nav.innerHTML = `<ul class="pagination justify-content-end">
        <li class="page-item${prevDisabled}">
          <a class="page-link" href="#" aria-label="Anterior"><span aria-hidden="true">&laquo;</span></a>
        </li>
        ${Array.from({ length: totalPages }, (_, i) =>
          `<li class="page-item${i + 1 === currentPage ? ' active' : ''}">
             <a class="page-link" href="#">${i + 1}</a>
           </li>`
        ).join('')}
        <li class="page-item${nextDisabled}">
          <a class="page-link" href="#" aria-label="Siguiente"><span aria-hidden="true">&raquo;</span></a>
        </li>
      </ul>`;

      host.appendChild(nav);

      const links = nav.querySelectorAll('.page-link');

      // « anterior
      links[0].addEventListener('click', e => {
        e.preventDefault();
        if (currentPage > 1) {
          currentPage--;
          renderPage(currentPage);
          createPagination();
        }
      });

      // Números
      links.forEach((a, idx) => {
        if (idx > 0 && idx < totalPages + 1) {
          a.addEventListener('click', e => {
            e.preventDefault();
            currentPage = idx;
            renderPage(currentPage);
            createPagination();
          });
        }
      });

      // » siguiente
      links[totalPages + 1].addEventListener('click', e => {
        e.preventDefault();
        if (currentPage < totalPages) {
          currentPage++;
          renderPage(currentPage);
          createPagination();
        }
      });
    }

    renderPage(currentPage);
    if (totalPages > 1) createPagination();
  }

  // ====== Reabrir modal "Nuevo" si hubo errores de validación en store ======
  if (window.becaTipoShowNuevoModal) {
    const nuevo = document.querySelector('#modalNuevo');
    if (nuevo) new bootstrap.Modal(nuevo).show();
  }
});
