document.addEventListener('DOMContentLoaded', () => {
  const editModal = new bootstrap.Modal('#modalEditar');
  const formEdit  = document.getElementById('formEditar');
  const eProg     = document.getElementById('editPrograma');
  const eTipo     = document.getElementById('editTipo');
  const eNombre   = document.getElementById('editNombre');
  const eActive   = document.getElementById('editActive');
  const ePeriodo  = document.getElementById('editPeriodo');

  const nPeriodo  = document.getElementById('newPeriodo');
  const nTipo     = document.getElementById('newTipo');

  // ===== Helper robusto: carga tipos por periodo con URL construida por Blade =====
      async function cargarTiposPorPeriodo(periodoId, selectDestino, selectedValue = '') {
      // Reset
      selectDestino.innerHTML = '';
      selectDestino.disabled = true;
    
      const placeholder = (txt) => {
        const opt = document.createElement('option');
        opt.value = '';
        opt.hidden = true;
        opt.textContent = txt;
        selectDestino.appendChild(opt);
      };
    
      if (!periodoId) {
        placeholder('Seleccione un periodo primero…');
        return;
      }
    
      try {
        // NUEVO: usamos prefijo y armamos la URL final
        const prefix = (window.URL_TIPOS_BY_PERIODO_PREFIX || '').toString().replace(/\/$/, '');
        if (!prefix) throw new Error('URL_TIPOS_BY_PERIODO_PREFIX no definida');
    
        const url = `${prefix}/${encodeURIComponent(periodoId)}`;
    
        const resp = await fetch(url, {
          method: 'GET',
          headers: { 'Accept': 'application/json' },
          credentials: 'same-origin'
        });
    
        const ct = resp.headers.get('content-type') || '';
        if (!resp.ok) throw new Error(`HTTP ${resp.status}`);
        if (!ct.includes('application/json')) {
          const text = await resp.text();
          console.error('Respuesta no JSON (¿login/HTML?):', text.slice(0, 500));
          throw new Error('Respuesta no JSON del servidor');
        }
    
        const data = await resp.json();
    
        placeholder(data.length ? 'Seleccione…' : 'No hay tipos para este periodo');
    
        data.forEach(t => {
          const opt = document.createElement('option');
          opt.value = t.id;
          opt.textContent = t.titulo;
          selectDestino.appendChild(opt);
        });
    
        selectDestino.disabled = (data.length === 0);
        if (selectedValue) selectDestino.value = String(selectedValue);
      } catch (err) {
        console.error('Error cargando tipos por periodo:', err);
        placeholder('Error cargando tipos');
        selectDestino.disabled = true;
      }
    }

  
  
  
  
  
  
  
  
  
  
  
  

  // ===== Nuevo: cuando cambie el periodo en "Nuevo", carga tipos =====
  nPeriodo?.addEventListener('change', () => {
    cargarTiposPorPeriodo(nPeriodo.value, nTipo);
  });

  // ===== Editar =====
  document.querySelectorAll('.btn-edit').forEach(btn => {
    btn.addEventListener('click', () => {
      const id       = btn.dataset.id;
      const programa = btn.dataset.programa || '';
      const tipo     = btn.dataset.tipo || '';
      const periodo  = btn.dataset.periodo || '';
      const nombre   = btn.dataset.nombre || '';
      const active   = parseInt(btn.dataset.active, 10) === 1;

      if (eProg)   eProg.value = programa;
      if (eNombre) eNombre.value = nombre;
      if (eActive) eActive.checked = active;

      if (ePeriodo) ePeriodo.value = periodo || '';

      // Carga tipos filtrados y preselecciona el tipo actual
      if (ePeriodo && eTipo) {
        cargarTiposPorPeriodo(ePeriodo.value, eTipo, tipo);
      }

      formEdit.action = '/admin/beca/beneficiario/' + id;
      editModal.show();
    });
  });

  // Al cambiar el periodo en editar
  ePeriodo?.addEventListener('change', () => {
    cargarTiposPorPeriodo(ePeriodo.value, eTipo);
  });

  // Mantén el resto de tu lógica (mostrar modal nuevo, eliminar, etc.)
  if (window.becaBeneficiarioShowNuevoModal) {
    new bootstrap.Modal('#modalNuevo').show();
  }

  document.addEventListener('click', function (e) {
    const btn = e.target.closest('.btn-delete');
    if (!btn) return;

    const url   = btn.getAttribute('data-url');
    const title = btn.getAttribute('data-title') || 'este beneficiario';

    const form = document.getElementById('formEliminar');
    const delTitle = document.getElementById('delTitulo');

    if (form && url) form.setAttribute('action', url);
    if (delTitle) delTitle.textContent = title;
  });
});
