
document.addEventListener('DOMContentLoaded', () => {
    // ======================
    // Preview PDF (modal)
    // ======================
    const pdfModal = new bootstrap.Modal('#modalPreviewPdf');
    const pdfFrame = document.getElementById('pdfFrame');
    const pdfTitle = document.getElementById('pdfTitle');
    const pdfNewTab = document.getElementById('pdfNewTab');

    document.querySelectorAll('.btn-preview-pdf').forEach(btn => {
        btn.addEventListener('click', () => {
            const url = btn.dataset.src || '#';
            const title = btn.dataset.title || 'Vista previa';
            if (pdfFrame) pdfFrame.src = url;
            if (pdfTitle) pdfTitle.textContent = title;
            if (pdfNewTab) pdfNewTab.href = url;
            pdfModal.show();
        });
    });

    // ======================
    // Editar (modal)
    // ======================
    const editModal = new bootstrap.Modal('#modalEditar');
    const formEdit = document.getElementById('formEditar');
    const eProg = document.getElementById('editPrograma');
    const eTurno = document.getElementById('editTurno');
    const eActive = document.getElementById('editActive');
    const eDocLink = document.getElementById('editDocLink');

    document.querySelectorAll('.btn-edit').forEach(btn => {
        btn.addEventListener('click', () => {
            const id   = btn.dataset.id;
            const prog = btn.dataset.programa;
            const turn = btn.dataset.turno;
            const doc  = btn.dataset.doc || '#';
            const act  = parseInt(btn.dataset.active, 10) === 1;

            if (eProg)   eProg.value = prog;
            if (eTurno)  eTurno.value = turn;
            if (eActive) eActive.checked = act;
            if (eDocLink) eDocLink.href = doc;

            if (formEdit) formEdit.action = `/admin/admision/resultados/${id}`;
            editModal.show();
        });
    });

    // Si el backend setea esta bandera, mostramos el modal de crear
    if (window.showModalNuevoOnError) {
        new bootstrap.Modal('#modalNuevo').show();
    }

    // ===========================
    // ELIMINAR (confirmar + submit de form oculto)
    // ===========================
    const delModal          = new bootstrap.Modal('#modalEliminar');
    const delTitle          = document.getElementById('delTitulo');
    const btnConfirmDelete  = document.getElementById('btnConfirmDelete');

    let formIdToSubmit = null; // ej: "del-form-12"

    // Al abrir el modal desde el botn de la fila, guardamos qu form enviar
    document.querySelectorAll('.btn-delete').forEach(btn => {
        btn.addEventListener('click', () => {
            formIdToSubmit = btn.dataset.form || null;
            if (delTitle) delTitle.textContent = btn.dataset.title || 'este resultado';
        });
    });

    // Confirmacin: enviamos el form oculto (DELETE real a la ruta con ID)
    if (btnConfirmDelete) {
        btnConfirmDelete.addEventListener('click', () => {
            if (!formIdToSubmit) return;
            const form = document.getElementById(formIdToSubmit);
            if (!form) return;

            // Feedback de proceso
            btnConfirmDelete.disabled = true;
            btnConfirmDelete.textContent = 'Eliminando...';

            // Enviar form nativo (igual que crear/editar, evita 405 por mtodos bloqueados)
            form.submit();
        });
    }

    // (Opcional) Helper para toasts si quieres usarlo en otras acciones
    function toast(message, type = 'success', ms = 1800) {
        const el = document.createElement('div');
        el.className = `alert alert-${type} position-fixed top-0 start-50 translate-middle-x mt-3 shadow`;
        el.style.zIndex = 1060;
        el.textContent = message;
        document.body.appendChild(el);
        setTimeout(() => el.remove(), ms);
    }
});
