// public/js/admin/admision_matricula/admision/proceso/proceso.js
document.addEventListener('DOMContentLoaded', () => {
  // ====== Modales y formularios ======
  const editModalEl   = document.querySelector('#modalEditar');
  const deleteModalEl = document.querySelector('#modalEliminar');

  const editModal   = editModalEl ? new bootstrap.Modal(editModalEl) : null;
  const deleteModal = deleteModalEl ? new bootstrap.Modal(deleteModalEl) : null;

  const formEdit   = document.getElementById('formEditar');
  const formDelete = document.getElementById('formEliminar');

  const ePaso   = document.getElementById('editPaso');
  const eDesc   = document.getElementById('editDesc');
  const eActive = document.getElementById('editActive');
  const delTit  = document.getElementById('delTitulo');

  // ====== EDITAR ======
  document.querySelectorAll('.btn-edit').forEach(btn => {
    btn.addEventListener('click', () => {
      const id     = btn.dataset.id;
      const paso   = btn.dataset.paso || '';
      const desc   = btn.dataset.desc || '';
      const active = parseInt(btn.dataset.active, 10) === 1;

      if (ePaso)   ePaso.value = paso;
      if (eDesc)   eDesc.value = desc;
      if (eActive) eActive.checked = active;

      // 1) Usar la URL completa que viene del Blade:
      let url = btn.dataset.updateUrl;

      // 2) Fallback opcional si definiste window.ADMIN_PROCESO_BASE en el Blade:
      if (!url && window.ADMIN_PROCESO_BASE) {
        url = String(window.ADMIN_PROCESO_BASE) + id;
      }

      if (!url) {
        console.error('No se pudo resolver la URL de actualizacin (falta data-update-url o ADMIN_PROCESO_BASE).');
        return;
      }

      if (formEdit) formEdit.action = url; // PUT /admin/admision/proceso/{id}

      if (editModal) editModal.show();
    });
  });

  // ====== ELIMINAR ======
  document.querySelectorAll('.btn-delete').forEach(btn => {
    btn.addEventListener('click', () => {
      if (!formDelete) return;
      const url = btn.dataset.url || '';
      if (!url) {
        console.error('El botn de eliminar no tiene data-url con la ruta a DELETE.');
        return;
      }
      formDelete.action = url; // DELETE /admin/admision/proceso/{id}
      if (delTit) delTit.textContent = btn.dataset.title || 'este registro';
      if (deleteModal) deleteModal.show();
    });
  });

  // ====== Paginacin (si agregas la clase .proceso-table a la tabla) ======
  let tableBody = document.querySelector('.proceso-table tbody');
  if (!tableBody) tableBody = document.querySelector('.content-table tbody'); // fallback a tu clase actual

  if (tableBody) {
    const rows = Array.from(tableBody.querySelectorAll('tr'));
    const dataRows = rows.filter(row => !row.classList.contains('no-data') && row.children.length > 3);
    const pageSize = 5;
    let currentPage = 1;
    const totalPages = Math.ceil(Math.max(dataRows.length, 1) / pageSize);

    function renderPage(page) {
      tableBody.innerHTML = '';
      const start = (page - 1) * pageSize;
      const end = start + pageSize;
      const pageRows = dataRows.slice(start, end);
      pageRows.forEach(row => tableBody.appendChild(row));
      if (pageRows.length === 0) {
        const noDataRow = document.createElement('tr');
        noDataRow.innerHTML = '<td colspan="5" class="text-center text-muted">Sin registros.</td>';
        tableBody.appendChild(noDataRow);
      }
    }

    function createPagination() {
      const table = tableBody.closest('table');
      const host  = table ? table.parentElement : tableBody.parentElement;

      host.querySelectorAll('.proceso-pagination').forEach(p => p.remove());

      const pagination = document.createElement('nav');
      pagination.className = 'proceso-pagination mt-3';

      const prevDisabled = currentPage === 1 ? ' disabled' : '';
      const nextDisabled = currentPage === totalPages ? ' disabled' : '';

      pagination.innerHTML = `<ul class="pagination justify-content-end">
        <li class="page-item${prevDisabled}">
          <a class="page-link" href="#" aria-label="Anterior"><span aria-hidden="true">&laquo;</span></a>
        </li>
        ${Array.from({ length: totalPages }, (_, i) =>
          `<li class="page-item${i + 1 === currentPage ? ' active' : ''}">
             <a class="page-link" href="#">${i + 1}</a>
           </li>`
        ).join('')}
        <li class="page-item${nextDisabled}">
          <a class="page-link" href="#" aria-label="Siguiente"><span aria-hidden="true">&raquo;</span></a>
        </li>
      </ul>`;

      host.appendChild(pagination);

      const pageLinks = pagination.querySelectorAll('.page-link');

      // 00 anterior
      pageLinks[0].addEventListener('click', e => {
        e.preventDefault();
        if (currentPage > 1) {
          currentPage--;
          renderPage(currentPage);
          createPagination();
        }
      });

      // nmeros
      pageLinks.forEach((link, idx) => {
        if (idx > 0 && idx < totalPages + 1) {
          link.addEventListener('click', e => {
            e.preventDefault();
            currentPage = idx;
            renderPage(currentPage);
            createPagination();
          });
        }
      });

      // 03 siguiente
      pageLinks[totalPages + 1].addEventListener('click', e => {
        e.preventDefault();
        if (currentPage < totalPages) {
          currentPage++;
          renderPage(currentPage);
          createPagination();
        }
      });
    }

    renderPage(currentPage);
    if (totalPages > 1) createPagination();
  }

  // Reabrir modal "Nuevo" si hubo validacin fallida del create
  if (window.showModalNuevoOnError) {
    const nuevo = document.querySelector('#modalNuevo');
    if (nuevo) new bootstrap.Modal(nuevo).show();
  }
});