// public/js/admin/admision_matricula/admision/pasos/pasos.js
document.addEventListener('DOMContentLoaded', () => {
  // ====== Referencias comunes ======
  const editModalEl = document.querySelector('#modalEditar');
  const deleteModalEl = document.querySelector('#modalEliminar');

  const editModal   = editModalEl ? new bootstrap.Modal(editModalEl) : null;
  const deleteModal = deleteModalEl ? new bootstrap.Modal(deleteModalEl) : null;

  const formEdit   = document.getElementById('formEditar');
  const formDelete = document.getElementById('formEliminar');

  const ePaso   = document.getElementById('editPaso');
  const eIcono  = document.getElementById('editIcono');
  const eActive = document.getElementById('editActive');
  const delTit  = document.getElementById('delTitulo');

  // Utilidad: obtiene la URL de update para EDITAR
  function resolveUpdateUrlFromBtn(btn, id) {
    // 1) Preferimos la URL exacta enviada desde Blade
    if (btn.dataset.updateUrl) return btn.dataset.updateUrl;

    // 2) Si definiste una base global antes de cargar este JS:
    // <script>window.ADMIN_PASOS_BASE = "{{ url('/admin/admision/paso') }}/";</script>
    if (window.ADMIN_PASOS_BASE) return String(window.ADMIN_PASOS_BASE) + id;

    // 3) Si dejaste antiguo window.adminPasosUpdateRoute con placeholder "__ID__"
    if (window.adminPasosUpdateRoute) return String(window.adminPasosUpdateRoute).replace('__ID__', id);

    // Si nada existe, devolvemos vaco (evita crashear)
    return '';
  }

  // ====== EDITAR ======
  document.querySelectorAll('.btn-edit').forEach(btn => {
    btn.addEventListener('click', () => {
      const id     = btn.dataset.id;
      const paso   = btn.dataset.paso  || '';
      const icono  = btn.dataset.icono || '';
      const active = parseInt(btn.dataset.active, 10) === 1;

      if (ePaso)  ePaso.value  = paso;
      if (eIcono) eIcono.value = icono;
      if (eActive) eActive.checked = active;

      if (formEdit) {
        const url = resolveUpdateUrlFromBtn(btn, id);
        if (!url) {
          console.error('No se pudo resolver la URL de actualizacin. Revisa data-update-url o ADMIN_PASOS_BASE.');
          return;
        }
        formEdit.action = url;           // PUT /admin/admision/paso/{id}
      }

      if (editModal) editModal.show();
    });
  });

  // ====== ELIMINAR ======
  document.querySelectorAll('.btn-delete').forEach(btn => {
    btn.addEventListener('click', () => {
      if (!formDelete) return;
      // data-url debe venir desde Blade con route('admin-pasos.destroy', ['paso' => $row->id])
      const url = btn.dataset.url || '';
      if (!url) {
        console.error('El botn de eliminar no tiene data-url con la ruta a DELETE.');
        return;
      }
      formDelete.action = url;           // DELETE /admin/admision/paso/{id}
      if (delTit) delTit.textContent = btn.dataset.title || 'este paso';
      if (deleteModal) deleteModal.show();
    });
  });

  // ====== Paginacin de tabla ======
  // Intentamos primero con .pasos-table tbody (si agregaste la clase),
  // de lo contrario usamos .content-table tbody (que es la clase que ya tienes en Blade).
  let tableBody = document.querySelector('.pasos-table tbody');
  if (!tableBody) tableBody = document.querySelector('.content-table tbody');

  if (tableBody) {
    const rows = Array.from(tableBody.querySelectorAll('tr'));
    const dataRows = rows.filter(row => !row.classList.contains('no-data') && row.children.length > 3);
    const pageSize = 5;
    let currentPage = 1;
    const totalPages = Math.ceil(Math.max(dataRows.length, 1) / pageSize);

    function renderPage(page) {
      tableBody.innerHTML = '';
      const start = (page - 1) * pageSize;
      const end = start + pageSize;
      const pageRows = dataRows.slice(start, end);
      pageRows.forEach(row => tableBody.appendChild(row));
      if (pageRows.length === 0) {
        const noDataRow = document.createElement('tr');
        noDataRow.innerHTML = '<td colspan="5" class="text-center text-muted">Sin registros.</td>';
        tableBody.appendChild(noDataRow);
      }
    }

    function createPagination() {
      // El paginador se agrega al contenedor de la tabla
      const table = tableBody.closest('table');
      const host  = table ? table.parentElement : tableBody.parentElement;

      // Limpia paginadores previos
      host.querySelectorAll('.pasos-pagination').forEach(p => p.remove());

      const pagination = document.createElement('nav');
      pagination.className = 'pasos-pagination mt-3';

      const prevDisabled = currentPage === 1 ? ' disabled' : '';
      const nextDisabled = currentPage === totalPages ? ' disabled' : '';

      pagination.innerHTML = `<ul class="pagination justify-content-end">
        <li class="page-item${prevDisabled}">
          <a class="page-link" href="#" aria-label="Anterior"><span aria-hidden="true">&laquo;</span></a>
        </li>
        ${Array.from({ length: totalPages }, (_, i) =>
          `<li class="page-item${i + 1 === currentPage ? ' active' : ''}">
             <a class="page-link" href="#">${i + 1}</a>
           </li>`
        ).join('')}
        <li class="page-item${nextDisabled}">
          <a class="page-link" href="#" aria-label="Siguiente"><span aria-hidden="true">&raquo;</span></a>
        </li>
      </ul>`;

      host.appendChild(pagination);

      const pageLinks = pagination.querySelectorAll('.page-link');

      // 00 anterior
      pageLinks[0].addEventListener('click', e => {
        e.preventDefault();
        if (currentPage > 1) {
          currentPage--;
          renderPage(currentPage);
          createPagination();
        }
      });

      // nmeros
      pageLinks.forEach((link, idx) => {
        if (idx > 0 && idx < totalPages + 1) {
          link.addEventListener('click', e => {
            e.preventDefault();
            currentPage = idx;
            renderPage(currentPage);
            createPagination();
          });
        }
      });

      // 03 siguiente
      pageLinks[totalPages + 1].addEventListener('click', e => {
        e.preventDefault();
        if (currentPage < totalPages) {
          currentPage++;
          renderPage(currentPage);
          createPagination();
        }
      });
    }

    renderPage(currentPage);
    if (totalPages > 1) createPagination();
  }

  // ====== Reabrir modal "Nuevo" si hubo validacin fallida del create ======
  if (window.adminPasosShowNuevoModal) {
    const nuevo = document.querySelector('#modalNuevo');
    if (nuevo) new bootstrap.Modal(nuevo).show();
  }
});