<?php

namespace App\Http\Controllers\web;

use App\Http\Controllers\Controller;
use App\Models\MensajeContacto;
use Illuminate\Http\Request;

class ContactoFormController extends Controller
{
    public function store(Request $request)
    {
        $data = $request->validate([
            'nombre'   => ['required', 'string', 'max:100'],
            'apellido' => ['required', 'string', 'max:100'],
            'correo'   => ['required', 'email', 'max:150'],
            'mensaje'  => ['required', 'string'],
        ]);

        MensajeContacto::create($data);

        // Redirige a una página de gracias o regresa con éxito
        return back()->with('success', '¡Tu mensaje fue enviado correctamente!');
    }
}
