<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Popup;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class PopupController extends Controller
{
    public function index()
    {
        $records = Popup::orderByDesc('id')->paginate(12);
        return view('admin.inicio.popup.index', compact('records'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'title'          => ['required','string','max:255'],
            'foto'           => ['required','image','mimes:jpg,jpeg,png,webp','max:4096'],
            'is_active'      => ['nullable','boolean'],
            'start_datetime' => ['nullable','date'],
            'end_datetime'   => ['nullable','date','after_or_equal:start_datetime'],
        ]);

        // subir imagen
        $destination = public_path('images/popups');
        if (!is_dir($destination)) mkdir($destination, 0775, true);

        $base     = pathinfo($request->file('foto')->getClientOriginalName(), PATHINFO_FILENAME);
        $filename = time().'_'.Str::slug($base);
        $ext      = $request->file('foto')->getClientOriginalExtension();
        $request->file('foto')->move($destination, "{$filename}.{$ext}");

        Popup::create([
            'title'          => $data['title'],
            'image'          => 'popups/'.$filename.'.'.$ext,
            'is_active'      => (bool)($data['is_active'] ?? false),
            'start_datetime' => $data['start_datetime'] ?? null,
            'end_datetime'   => $data['end_datetime'] ?? null,
        ]);

        return back()->with('success','Popup creado correctamente.');
    }

    public function update(Request $request, Popup $popup)
    {
        $data = $request->validate([
            'title'          => ['required','string','max:255'],
            'foto'           => ['nullable','image','mimes:jpg,jpeg,png,webp','max:4096'],
            'is_active'      => ['nullable','boolean'],
            'start_datetime' => ['nullable','date'],
            'end_datetime'   => ['nullable','date','after_or_equal:start_datetime'],
        ]);

        $popup->title          = $data['title'];
        $popup->is_active      = (bool)($data['is_active'] ?? false);
        $popup->start_datetime = $data['start_datetime'] ?? null;
        $popup->end_datetime   = $data['end_datetime'] ?? null;

        if ($request->hasFile('foto')) {
            $old = public_path('images/'.$popup->image);
            if (is_file($old)) @unlink($old);

            $destination = public_path('images/popups');
            if (!is_dir($destination)) mkdir($destination, 0775, true);

            $base     = pathinfo($request->file('foto')->getClientOriginalName(), PATHINFO_FILENAME);
            $filename = time().'_'.Str::slug($base);
            $ext      = $request->file('foto')->getClientOriginalExtension();
            $request->file('foto')->move($destination, "{$filename}.{$ext}");

            $popup->image = 'popups/'.$filename.'.'.$ext;
        }

        $popup->save();
        return back()->with('success','Popup actualizado correctamente.');
    }

    public function destroy(Popup $popup)
    {
        $popup->delete(); // soft delete
        return back()->with('success','Popup eliminado.');
    }
}
