<?php

namespace App\Http\Controllers;

use App\Models\Sistema;
use Illuminate\Http\Request;

class SistemaController extends Controller
{
    private function icons(): array
    {
        return [
            'fa-solid fa-user-graduate' => 'Estudiantes',
            'fa-solid fa-user-check'    => 'Egresados',
            'fa-solid fa-hourglass'     => 'Años de servicio',
            'fa-solid fa-diagram-project' => 'Programas',
            'fa-solid fa-users'         => 'Usuarios',
            'fa-solid fa-building'      => 'Edificio',
            'fa-solid fa-flask'         => 'Laboratorio',
            'fa-solid fa-book'          => 'Libro',
            'fa-solid fa-book-open'     => 'Libro (abierto)',
        ];
    }

    public function index()
    {
        $sistemas = Sistema::orderBy('id', 'asc')->get();
        $icons = $this->icons();
        return view('admin.inicio.sistemas.index', compact('sistemas', 'icons'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'nombre' => 'required|string|max:100',
            'icono'  => 'required|string|max:100',
            'link'   => 'required|string|max:255',
        ]);

        Sistema::create($request->all());
        return back()->with('success', 'Sistema agregado correctamente.');
    }

    public function update(Request $request, Sistema $sistema)
    {
        $request->validate([
            'nombre' => 'required|string|max:100',
            'icono'  => 'required|string|max:100',
            'link'   => 'required|string|max:255',
        ]);

        $sistema->update($request->all());
        return back()->with('success', 'Sistema actualizado correctamente.');
    }

    public function destroy(Sistema $sistema)
    {
        $sistema->delete();
        return back()->with('success', 'Sistema eliminado correctamente.');
    }
}
