<?php

namespace App\Http\Controllers;

use App\Models\PeriodoAcademico;
use Illuminate\Http\Request;

class PeriodoAcademicoController extends Controller
{
    public function index()
    {
        $items = PeriodoAcademico::orderBy('nombre')->get();
        return view('admin.admision_matricula.beca.periodos.index', compact('items'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'nombre' => ['required', 'string', 'max:150', 'unique:periodos_academicos,nombre'],
            'estado' => ['nullable', 'boolean'],
        ]);

        PeriodoAcademico::create([
            'nombre' => $data['nombre'],
            'estado' => $request->boolean('estado'),
        ]);

        return back()->with('success', 'Periodo creado.');
    }

    public function update(Request $request, PeriodoAcademico $periodo)
    {
        $data = $request->validate([
            'nombre' => ['required', 'string', 'max:150', 'unique:periodos_academicos,nombre,' . $periodo->id],
            'estado' => ['nullable', 'boolean'],
        ]);

        $periodo->update([
            'nombre' => $data['nombre'],
            'estado' => $request->has('estado') ? 1 : 0,
        ]);

        return back()->with('success', 'Periodo actualizado.');
    }

    public function destroy(PeriodoAcademico $periodo)
    {
        if ($periodo->becasTipos()->exists()) {
            return back()->withErrors('No se puede eliminar: hay becas vinculadas a este periodo.');
        }

        $periodo->delete();
        return back()->with('success', 'Periodo eliminado.');
    }
}
