<?php

// app/Http/Controllers/HomeController.php
namespace App\Http\Controllers;

use App\Models\InicioHero;
use App\Models\InicioServicio;
use App\Models\InicioEstadistica;
use App\Models\ProgramasEstudio;
use App\Models\Noticia;
use App\Models\PlanaJerarquica;
use App\Models\InicioBeneficio;
use App\Models\InicioTestimonio;
use App\Models\Popup;
use App\Models\Slider;
use App\Models\Sistema;

class HomeController extends Controller
{
    public function index()
    {
        $hero = InicioHero::where('is_active', 1)->orderByDesc('id')->first();

        $servicios     = InicioServicio::where('is_active', 1)->orderBy('id')->get(['nombre','descripcion','icono']);
        $estadisticas  = InicioEstadistica::active()->orderBy('id')->get();
        $programas     = ProgramasEstudio::active()->orderBy('id')->get();
        $noticias      = Noticia::active()->orderByDesc('fecha')->orderByDesc('id')->take(3)->get();
        $coordinadores = PlanaJerarquica::active()->orderBy('id')->get(['nombre','cargo','imagen']);
        $beneficios    = InicioBeneficio::where('is_active',1)->orderBy('id')->get(['nombre','descripcion','icono']);
        $testimonios   = InicioTestimonio::active()->orderBy('id')->get(['nombre','descripcion','imagen','puntuacion']);
        $activos       = Popup::published()->orderBy('start_datetime')->orderBy('id')->get();

        // NUEVO: sistemas para la columna derecha
        $sistemas = Sistema::where('is_active', 1)
            ->orderBy('id')
            ->get(['nombre','icono','link']);

        $sliders = Slider::where('is_active', 1)->orderBy('id','asc')->get(['id','foto']);

        return view('welcome', compact(
            'hero','servicios','estadisticas','programas','noticias',
            'coordinadores','beneficios','testimonios','activos','sliders',
            'sistemas' // ← añade esto
        ));
    }
}
