<?php

namespace App\Http\Controllers\home;

use App\Http\Controllers\Controller;
use App\Models\Subjectenrollment;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class StudenthomeController extends Controller
{

    public function homeStudentData()
    {

        $userId = Auth::User()->id;

        $result = SubjectEnrollment::select(
            'cursos.codcurso',
            'cursos.nombre AS curso',
            'cursos.tipo',
            'cursos.creditos',
            'periodos.numero AS periodo',
            DB::raw("CONCAT(semestres.anho,'-',semestres.numero) AS semestre"),
            'matriculas_asignaturas.nota',
            'asignaturas.silabo',
            'asignaturas.instrumentos_evaluacion',
            'asignaturas.id as idsubject'
        )
            ->join('asignaturas', 'asignaturas.id', '=', 'matriculas_asignaturas.subject_id')
            ->join('cursos', 'cursos.id', '=', 'asignaturas.course_id')
            ->join('periodos', 'periodos.id', '=', 'cursos.period_id')
            ->join('semestres', 'semestres.id', '=', 'asignaturas.semester_id')
            ->join('estudiantes', 'estudiantes.id', '=', 'matriculas_asignaturas.student_id')
            ->where('estudiantes.user_id', '=', $userId)
            ->orderByRaw('semestre DESC')
            ->get();

        if ($result->count() > 0) {
            return response()->json([
                "status" => true,
                "mensaje" => 'Éxito, datos encontrados',
                "data" => $result,
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, datos null',
                "data" => [],
            ]);
        }
    }
    public function list_history_cursos(Request $request)
    {

        $userId = Auth::User()->id;

        if ($request->ajax()) {
            // query

            $data = DB::table('matriculas_asignaturas')
                ->select(
                    DB::raw("CONCAT(semestres.anho,'-',semestres.numero) AS semestre"),
                    'estudiantes.user_id',
                    'cursos.codcurso',
                    'cursos.nombre as curso',
                    DB::raw("CONCAT(usuarios.nombres,' ', usuarios.apellido_pa,' ', usuarios.apellido_ma) AS docente"),
                    'cursos.tipo',
                    'asignaturas.seccion',
                    'asignaturas.turno',
                    'cursos.horas',
                    'cursos.creditos',
                    'periodos.numero as periodo',
                    DB::raw("IF(matriculas_asignaturas.nota IS NULL, 0, matriculas_asignaturas.nota) AS notalumno"),
                    'asignaturas.silabo',
                    'asignaturas.instrumentos_evaluacion',
                    'asignaturas.id as idsubject'
                )
                ->join('asignaturas', 'asignaturas.id', '=', 'matriculas_asignaturas.subject_id')
                ->join('docentes', 'asignaturas.teacher_id', '=', 'docentes.id')
                ->join('cursos', 'cursos.id', '=', 'asignaturas.course_id')
                ->join('periodos', 'periodos.id', '=', 'cursos.period_id')
                ->join('semestres', 'semestres.id', '=', 'asignaturas.semester_id')
                ->join('estudiantes', 'estudiantes.id', '=', 'matriculas_asignaturas.student_id')
                ->join('usuarios', 'usuarios.id', '=', 'docentes.user_id')
                ->where('estudiantes.user_id', '=', $userId)
                ->orderByDesc('semestre')
                ->get();

            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
        return response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los estudiantes']);
    }
}
