<?php

namespace App\Http\Controllers\egresados;

use App\Http\Controllers\Controller;
use App\Models\Socioeconomicsheet;
use Illuminate\Http\Request;
use App\Models\Student;


class Datosegresado extends Controller
{
    public function index()
    {
        return view('datosegresado.index');
    }

    public function query_data(Request $request, $nroidenti)
    {
        if ($request->ajax()) {

            $data =  Student::select(
                'estudiantes.id',
                'usuarios.nombres',
                'usuarios.apellido_pa',
                'usuarios.apellido_ma',
                'usuarios.nroidenti',
                'generos.nombre as genero',
                'estudiantes.anho_ingreso',
                'programas.nombre as programa',
                'usuarios.direccion',
                'usuarios.correo',
                'usuarios.celular',
                'fichas_socioeconomicas.flg_trabaja',
                'fichas_socioeconomicas.empresa',
                'fichas_socioeconomicas.tipo_empresa',
                'fichas_socioeconomicas.ingreso_mensual',
                'fichas_socioeconomicas.estado_civil',
                'fichas_socioeconomicas.rubro_empresa',
                'fichas_socioeconomicas.nro_hijos',
                'fichas_socioeconomicas.tipovivienda',
                'fichas_socioeconomicas.nombre_jefe',
                'fichas_socioeconomicas.ocupacion',
                'fichas_socioeconomicas.forma_contrato',
                'fichas_socioeconomicas.gastos_mensuales',
                'fichas_socioeconomicas.flg_antes_trabajaba',
                'fichas_socioeconomicas.meses_no_trabaja',
                'fichas_socioeconomicas.explicacion',
                'fichas_socioeconomicas.form_prof_recibida',
                'fichas_socioeconomicas.carrera_satis_necesi',
                'fichas_socioeconomicas.area_carrera_profesiona_beneficiado',
                'fichas_socioeconomicas.satisfecho_form_institu_brindo',
                'fichas_socioeconomicas.motivos_satisfecho_form_institu_brindo',
                'fichas_socioeconomicas.razon_form_institu_brindo',
            )
                ->join('usuarios', 'usuarios.id', '=', 'estudiantes.user_id')
                ->join('generos', 'generos.id', '=', 'usuarios.genre_id')
                ->join('planes', 'planes.id', '=', 'estudiantes.plan_id')
                ->join('programas', 'programas.id', '=', 'planes.program_id')
                ->leftjoin('fichas_socioeconomicas', 'fichas_socioeconomicas.student_id', '=', 'estudiantes.id')
                ->where('estudiantes.estado', '=', 5) // egresado
                ->where('usuarios.nroidenti', '=', $nroidenti)
                ->distinct()
                ->get();
            // datatabl
            if (count($data) > 0) {
                return response()->json(["status" => true, "mensaje" => 'registro encontrado', "data" => $data]);
            } else {
                return response()->json(["status" => false, "mensaje" => 'registro no encontrado', "data" => []]);
            }
        }

        return response()->json(["status" => false, "mensaje" => 'Error: no se pudo realizar consulta']);
    }

    public function store(Request $request)
    {
        if ($request->ajax()) {
            $studentId = $request->input('hidden_student');

            // Buscar el registro existente por el ID del estudiante
            $Socioeconomicsheet = Socioeconomicsheet::where('student_id', $studentId)->first();
            if (!$Socioeconomicsheet) {
                $Socioeconomicsheet = new Socioeconomicsheet();
            }
            $Socioeconomicsheet->estado_civil = $request->input('txt_civil');
            $Socioeconomicsheet->nro_hijos = $request->input('txt_numhijos');
            $Socioeconomicsheet->ingreso_mensual = $request->input('txt_remuneracion');
            $Socioeconomicsheet->ocupacion = $request->input('txt_cargo');
            $Socioeconomicsheet->empresa = $request->input('txt_nomempresa');
            $Socioeconomicsheet->tipovivienda = $request->input('txt_tipovivienda');
            $Socioeconomicsheet->gastos_mensuales = $request->input('txt_gastos');

            $Socioeconomicsheet->flg_trabaja = $request->input('txt_trabaja');
            $Socioeconomicsheet->rubro_empresa = $request->input('txt_rubro');
            $Socioeconomicsheet->tipo_empresa = $request->input('txt_tipoempresa');
            $Socioeconomicsheet->nombre_jefe = $request->input('txt_jefe');
            $Socioeconomicsheet->forma_contrato = $request->input('txt_formacontrato');
            $Socioeconomicsheet->flg_antes_trabajaba = $request->input('txt_anteriormente');
            $Socioeconomicsheet->meses_no_trabaja = $request->input('txt_negativopositivo');
            $Socioeconomicsheet->explicacion = $request->input('txt_porque');
            $Socioeconomicsheet->form_prof_recibida = $request->input('txt_explicacionlaboral');
            $Socioeconomicsheet->carrera_satis_necesi = $request->input('txt_satisface');
            $Socioeconomicsheet->area_carrera_profesiona_beneficiado = $request->input('txt_beneficiado');
            $Socioeconomicsheet->satisfecho_form_institu_brindo = $request->input('txt_conforme');
            $Socioeconomicsheet->motivos_satisfecho_form_institu_brindo = $request->input('txt_motivos');
            $Socioeconomicsheet->razon_form_institu_brindo = $request->input('txt_motivos_razon');

            $Socioeconomicsheet->student_id = $studentId;

            if ($Socioeconomicsheet->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
            }
        } else {
            return response()->json(["status" => false, "mensaje" => 'Error: no se pudo realizar consulta']);
        }
    }
}
