<?php

namespace App\Http\Controllers\docente;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use App\Models\Subject;
use App\Models\Folder;
use App\Models\Subfolder;
use App\Models\Folderfile;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;

class MaterialesRecursosController extends Controller
{
    //
    public function index(Request $request)
    {
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                $tipoacceso = 2;
                return view('docente.materiales_recursos.index')->with('datatipoacceso', $tipoacceso);
            } else if ($userTypeAccesocombo == "1") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.adm.dashboard')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    public function ajax_all(Request $request, $idsemester)
    {
        if ($request->ajax()) {

            $idUsuario = Auth::User()->id;

            $data = Subject::select(
                'asignaturas.id AS id', 
                'asignaturas.seccion', 
                'asignaturas.turno', 
                'cu.id AS idcourse', 
                'cu.codcurso', 
                'cu.nombre AS namecurso')
            ->join('cursos AS cu', 'asignaturas.course_id', '=', 'cu.id')
            ->join('docentes AS doc', 'asignaturas.teacher_id', '=', 'doc.id')
            ->join('usuarios AS us', 'doc.user_id', '=', 'us.id')
            ->where('us.id', $idUsuario)
            ->where('asignaturas.semester_id', $idsemester)
            ->orderBy('cu.nombre')
            ->get();
            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }
    public function list_folders(Request $request, $idsubject)
    {
        if ($request->ajax()) {

            DB::statement("SET lc_time_names = 'es_ES'");

            $data = DB::table('carpetas as c')
                ->select(
                    'c.subject_id as idsubject',
                    'c.id as idfolder',
                    'c.nombre as nombre',
                    'c.descripcion as descripcion',
                    'c.estado as estado',
                    DB::raw("DATE_FORMAT(c.updated_at, '%d de %M, %Y') AS fecha"),
                    DB::raw("DATE_FORMAT(c.updated_at, '%H:%i %p') AS hora")
                    )
                ->where('c.subject_id', $idsubject)
                ->get();

            return response()->json($data);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function store_folder(Request $request)
    {
        $item = new Folder();
        $item->nombre = $request->input('dt_folder-nombre');
        $item->descripcion = $request->input('dt_folder-descripcion');
        $item->estado = "1";
        $item->subject_id = $request->input('dt_folder-subject_id');

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }

    public function update_folder(Request $request, $idfolder)
    {
        $item = Folder::find($idfolder);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->nombre = $request->input('dt_folder-nombre');
            $item->descripcion = $request->input('dt_folder-descripcion');

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }

    public function destroy_folder($idfolder)
    {
        // Busca el registro por su ID
        $item = Folder::find($idfolder);

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }



    public function list_subfolders(Request $request, $idfolder)
    {
        if ($request->ajax()) {
            $data = DB::table('subcarpetas as s')
                ->select(
                    's.id as idsubfolder',
                    's.folder_id as idfolder',
                    's.nombre as nombre',
                    DB::raw("DATE_FORMAT(s.updated_at, '%d de %M, %Y') AS fecha"),
                    DB::raw("DATE_FORMAT(s.updated_at, '%H:%i %p') AS hora")
                    )
                ->where('s.folder_id', $idfolder)
                ->get();

            return response()->json($data);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function store_subfolder(Request $request)
    {
        $item = new Subfolder();
        $item->folder_id = $request->input('dt_subfolder-folder_id');
        $item->nombre = $request->input('dt_subfolder-nombre');

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }


    public function update_subfolder(Request $request, $idsubfolder)
    {
        $item = Subfolder::find($idsubfolder);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->nombre = $request->input('dt_subfolder-nombre');

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy_subfolder($idsubfolder)
    {
        // Busca el registro por su ID
        $item = Subfolder::find($idsubfolder);

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }


    public function list_folderfiles(Request $request, $idsubfolder)
    {
        if ($request->ajax()) {
            $data = DB::table('archivos_carpetas AS ac')
                ->join('subcarpetas AS s', 's.id', '=', 'ac.subfolder_id')
                ->join('carpetas AS c', 'c.id', '=', 's.folder_id')
                ->join('asignaturas AS a', 'a.id', '=', 'c.subject_id')
                ->select(
                    'a.id AS idsubject',
                    'c.id AS idfolder',
                    's.id AS idsubfolder',
                    'ac.id AS idfolderfile',
                    'ac.ruta AS ruta',
                    'ac.archivo AS archivo',
                    DB::raw("DATE_FORMAT(ac.created_at, '%d de %M, %Y') AS fecha"),
                    DB::raw("DATE_FORMAT(ac.created_at, '%H:%i %p') AS hora")
                )
                ->where('ac.subfolder_id', '=', $idsubfolder)
                ->get();

             // Agregar el tamaño de cada archivo al resultado
            foreach ($data as $file) {
                $filePath = $file->ruta;
                $fileSize = Storage::size($filePath);
                // Convertir a kilobytes
                $file->tamaño = number_format($fileSize / 1024, 0, '.', ',');
            }

            return response()->json($data);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function store_folderfile(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'dt_folderfile-archivo' => 'required|file|max:5000', // Ejemplo: PDF, PPT, Excel, imágenes (hasta 5MB)
        ], [
            'dt_folderfile-archivo.required' => 'El archivo es requerido.',
            'dt_folderfile-archivo.file' => 'El archivo debe ser un tipo permitido.',
            'dt_folderfile-archivo.max' => 'El tamaño del archivo no debe superar los 5 MB.',
        ]);

        if ($validator->fails()) {
            return response()->json(["status" => false, "mensaje" => $validator->errors()]);
        } else {
            if ($request->hasFile('dt_folderfile-archivo')) {

                $folderName = Auth::User()->nroidenti . '/' . $request->input('dt_folderfile-subject_id'). '/' . $request->input('dt_folderfile-folder_id'). '/' . $request->input('dt_folderfile-subfolder_id');
                Storage::disk('local')->makeDirectory('public/materiales_recursos/' . $folderName); // creamos la carpeta en el disco local
                $archivo = $request->file('dt_folderfile-archivo'); // obtenemos el archivo
                $archivo->storeAs('public/materiales_recursos/' . $folderName, $archivo->getClientOriginalName()); // guardado (ruta,nombre del archivo)
                $filePath = 'public/materiales_recursos/' . $folderName . '/' . $archivo->getClientOriginalName(); // ruta del archivo

                $item = new Folderfile();

                $item->subfolder_id = $request->input('dt_folderfile-subfolder_id');
                $item->ruta = $filePath ;
                $item->archivo = $archivo->getClientOriginalName();

                if ($item->save()) {
                    return response()->json(["status" => true, "mensaje" => 'Archivo Cargado']);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                }
            } else {
                return response()->json([
                    'status' => false,
                    'mensaje' => 'Error de envio de archivo por HTTP'
                ]);
            }
        }
    }


    public function destroy_folderfile(Request $request, $idfolderfile)
    {
        // Busca el registro por su idfolderfile
        $item = Folderfile::find($idfolderfile);

        // recuperar data
        $ruta = $item->ruta;

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        $file = storage_path('app/') . $ruta;
        if (File::exists($file)) {
            File::delete($file);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }

    public function download_folderfile($idfolderfile)
    {
        // Buscar la ruta del archivo en la base de datos
        $item =  Folderfile::find($idfolderfile);

        // recuperar data
        $ruta = $item->ruta;

        // Verificar si la ruta del archivo existe
        if ($ruta) {
            // Obtener la ruta completa al archivo en el almacenamiento
            $rutaCompleta = Storage::path($ruta);

            // Verificar si el archivo existe en el almacenamiento
            if (Storage::exists($ruta)) {

                // Devolver el archivo como una descarga
                return response()->download($rutaCompleta, $item->archivo);
            } else {
                // Si el archivo no existe, devolver una respuesta JSON con un mensaje de error
                return response()->json([
                    "status" => false,
                    "mensaje" => 'El archivo no existe en el almacenamiento'
                ]);
            }
        } else {
            // Si no se encuentra la ruta del archivo en la base de datos, devolver un mensaje de error
            return response()->json([
                "status" => false,
                "mensaje" => 'La ruta del archivo no está disponible'
            ]);
        }
    }

}
