<?php

namespace App\Http\Controllers\docente;

use App\Http\Controllers\Controller;
use App\Models\Semesterperiod;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;
use \Illuminate\Support\Facades\Auth;

class DocenteHorariosController extends Controller
{

    public function index(Request $request)
    {

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                $tipoacceso = 2;
                return view('docente.horarios.index')->with('datatipoacceso', $tipoacceso);
            } else if ($userTypeAccesocombo == "1") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.adm.dashboard')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    public function list_info_semestres(Request $request, $idplan)
    {
        try {

            $user = Auth::User();
            $docentedata = $user->teachers;
            $iddocente = $docentedata[0]->id;

            if ($request->ajax()) {

                $result = Semesterperiod::select('periodos.id', 'periodos.numero AS periodos')
                    ->join('semestres', 'semestres.id', '=', 'periodos_semestres.semester_id')
                    ->join('asignaturas', 'semestres.id', '=', 'asignaturas.semester_id')
                    ->join('periodos', 'periodos.id', '=', 'periodos_semestres.period_id')
                    ->distinct()
                    ->where('asignaturas.teacher_id', '=', $iddocente)
                    ->where('periodos.plan_id', '=', $idplan)
                    ->orderBy('periodos')
                    ->get();

                return response()->json($result);
            } else {
                return response()->json([
                    'estado' => false,
                    'mensaje' => "error de consulta",
                ]);
            }
        } catch (Exception $e) {

            return response()->json([
                'estado' => false,
                'type' => 'Catch',
                'mensaje' => $e,
            ]);
        }
    }

    public function list_horario_docente(Request $request, $idsemestre)
    {

        if ($request->ajax()) {


            $user = Auth::user();
            $docenteData = $user->teachers;

            if ($idsemestre == 0) {
                $data = DB::table('asignaturas')
                    ->select(
                        'programas.nombre AS programa',
                        'planes.nombre AS plan',
                        'periodos.numero AS periodo',
                        'cursos.codcurso',
                        'cursos.nombre AS curso',
                        'cursos.tipo',
                        'asignaturas.tipo AS condicion',
                        'asignaturas.turno',
                        'asignaturas.seccion',
                        DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Lunes" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END), "-") AS Lunes'),
                        DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Martes" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END), "-") AS Martes'),
                        DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Miercoles" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END), "-") AS Miercoles'),
                        DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Jueves" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END), "-") AS Jueves'),
                        DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Viernes" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END), "-") AS Viernes'),
                        DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Sabado" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END), "-") AS Sabado'),
                        DB::raw('COALESCE(aulas.numero, "-") AS aula')
                    )
                    ->join('semestres', 'semestres.id', '=', 'asignaturas.semester_id')
                    ->leftJoin('horarios', 'horarios.subject_id', '=', 'asignaturas.id')
                    ->leftJoin('aulas', 'aulas.id', '=', 'horarios.classroom_id')
                    ->join('cursos', 'cursos.id', '=', 'asignaturas.course_id')
                    ->join('periodos', 'periodos.id', '=', 'cursos.period_id')
                    ->join('planes', 'planes.id', '=', 'periodos.plan_id')
                    ->join('programas', 'programas.id', '=', 'planes.program_id')
                    ->where('asignaturas.teacher_id', '=', $docenteData[0]->id)
                    ->groupBy(
                        'programa',
                        'plan',
                        'periodo',
                        'cursos.codcurso',
                        'cursos.nombre',
                        'cursos.tipo',
                        'condicion',
                        'asignaturas.turno',
                        'asignaturas.seccion',
                        'periodos.numero',
                        'semestres.id',
                        'aula'
                    )
                    ->orderBy('periodo')
                    ->get();
            } else {
                $data = DB::table('asignaturas')
                    ->select(
                        'programas.nombre AS programa',
                        'planes.nombre AS plan',
                        'periodos.numero AS periodo',
                        'cursos.codcurso',
                        'cursos.nombre AS curso',
                        'cursos.tipo',
                        'asignaturas.tipo AS condicion',
                        'asignaturas.turno',
                        'asignaturas.seccion',
                        DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Lunes" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END), "-") AS Lunes'),
                        DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Martes" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END), "-") AS Martes'),
                        DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Miercoles" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END), "-") AS Miercoles'),
                        DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Jueves" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END), "-") AS Jueves'),
                        DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Viernes" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END), "-") AS Viernes'),
                        DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Sabado" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END), "-") AS Sabado'),
                        DB::raw('COALESCE(aulas.numero, "-") AS aula')
                    )
                    ->join('semestres', 'semestres.id', '=', 'asignaturas.semester_id')
                    ->leftJoin('horarios', 'horarios.subject_id', '=', 'asignaturas.id')
                    ->leftJoin('aulas', 'aulas.id', '=', 'horarios.classroom_id')
                    ->join('cursos', 'cursos.id', '=', 'asignaturas.course_id')
                    ->join('periodos', 'periodos.id', '=', 'cursos.period_id')
                    ->join('planes', 'planes.id', '=', 'periodos.plan_id')
                    ->join('programas', 'programas.id', '=', 'planes.program_id')
                    ->where('asignaturas.teacher_id', '=', $docenteData[0]->id)
                    ->where('semestres.id', $idsemestre)
                    ->groupBy(
                        'programa',
                        'plan',
                        'periodo',
                        'cursos.codcurso',
                        'cursos.nombre',
                        'cursos.tipo',
                        'condicion',
                        'asignaturas.turno',
                        'asignaturas.seccion',
                        'periodos.numero',
                        'semestres.id',
                        'aula'
                    )
                    ->orderBy('periodo')
                    ->get();
            }


            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos',
        ]);
    }
}
