<?php

namespace App\Http\Controllers\alumno;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class HorarioController extends Controller
{

    public function index(Request $request)
    {

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                $tipoacceso = 3;
                return view('alumno.horarios.index')->with('datatipoacceso', $tipoacceso);
            } else if ($userTypeAccesocombo == "1") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.adm.dashboard')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    public function list_info(Request $request)
    {
        $user = Auth::user();
        $studentdata = $user->students;
        $idstudent = $studentdata[0]->id;

        if ($request->ajax()) {
            DB::statement("SET lc_time_names = 'es_ES'");

            $data = DB::table('estudiantes as st')
            ->select(
                'st.id as idstudent',
                'st.user_id as iduser',
                'pr.codprograma',
                'pr.nombre as programa',
                'pr.nivel_formativo',
                'pl.nombre as plan',
                'pl.tipo',
                'pl.modalidad',
                'pl.enfoque',
                // DB::raw('CONCAT(se.anho, "-", se.numero) as semestre'),
                // DB::raw('DATE_FORMAT(se.fecinicio, "%d - %M") as fecinicio'),
                // DB::raw('DATE_FORMAT(se.fecfin, "%d - %M") as fecfin')
            )
            ->join('planes as pl', 'pl.id', '=', 'st.plan_id')
            ->join('programas as pr', 'pr.id', '=', 'pl.program_id')
            // ->join('matriculas_semestres as seen', 'seen.student_id', '=', 'st.id')
            // ->join('semestres as se', 'se.id', '=', 'seen.semester_id')
            ->where('st.id', '=', $idstudent)
            // ->where('se.id', '=', $idsemester)
            ->get();

            return response()->json($data);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }

    public function list_horario(Request $request)
    {
        if ($request->ajax()) {

            $idsemester = $request->input('idsemester');

            $user = Auth::user();
            $studentdata = $user->students;
            $studentdata[0]->id;

            $data = DB::table('asignaturas')
                ->select(
                    'cursos.codcurso',
                    'cursos.nombre AS curso',
                    'cursos.tipo',
                    'asignaturas.tipo AS condicion',
                    'asignaturas.turno',
                    'asignaturas.seccion',
                    'periodos.numero AS periodo',
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Lunes" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END), "-") AS Lunes'),
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Martes" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END), "-") AS Martes'),
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Miercoles" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END), "-") AS Miercoles'),
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Jueves" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END), "-") AS Jueves'),
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Viernes" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END), "-") AS Viernes'),
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Sabado" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END), "-") AS Sabado'),
                    DB::raw('COALESCE(CONCAT(usuarios.nombres, " ", usuarios.apellido_pa, " ", usuarios.apellido_ma), "-") AS docente'),
                    DB::raw('COALESCE(aulas.numero, "-") AS aula')
                )
                ->leftJoin('docentes', 'docentes.id', '=', 'asignaturas.teacher_id')
                ->leftJoin('usuarios', 'usuarios.id', '=', 'docentes.user_id')
                ->join('matriculas_asignaturas', 'asignaturas.id', '=', 'matriculas_asignaturas.subject_id')
                ->join('estudiantes', 'estudiantes.id', '=', 'matriculas_asignaturas.student_id')
                ->join('semestres', 'semestres.id', '=', 'asignaturas.semester_id')
                ->leftJoin('horarios', 'horarios.subject_id', '=', 'asignaturas.id')
                ->leftJoin('aulas', 'aulas.id', '=', 'horarios.classroom_id')
                ->join('cursos', 'cursos.id', '=', 'asignaturas.course_id')
                ->join('periodos', 'periodos.id', '=', 'cursos.period_id')
                ->join('planes', 'planes.id', '=', 'periodos.plan_id')
                ->where('semestres.id', $idsemester)
                ->where('estudiantes.id', $studentdata[0]->id)
                ->groupBy(
                    'cursos.codcurso',
                    'cursos.nombre',
                    'cursos.tipo',
                    'condicion',
                    'asignaturas.turno',
                    'asignaturas.seccion',
                    'periodos.numero',
                    'semestres.id',
                    'docentes.user_id',
                    'docente',
                    'aula'
                )
                ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }
}
