<?php

namespace App\Http\Controllers\alumno;

use App\Http\Controllers\Controller;
use App\Models\Encuesta;
use App\Models\RespuestaUsuario;
use Illuminate\Http\Request;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class EncuestasController extends Controller
{


    public function index(Request $request)
    {

        if (Auth::check()) {

            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "3" && ($idusertype == "3" || $idusertype == "5" || $idusertype == "6" || $idusertype == "7")) {

                $tipoacceso = 3;

                // Suponiendo que el valor viene como un parámetro llamado "key"
                $rawValue = $request->encuesta; // Esto sería "r8loFqHP97:5"

                // Extraer el primer segmento antes del ":"
                $idencuesta = explode(':', $rawValue)[1];
                $userId = Auth::User()->id;

                $result = DB::table('encuestas AS e')
                    ->join('planes AS pl', 'e.plan_id', '=', 'pl.id')
                    ->leftJoin('respuestas_usuarios AS ru', function ($join) use ($userId) {
                        $join->on('ru.pregunta_id', '=', DB::raw('(SELECT p.id FROM preguntas AS p WHERE p.encuesta_id = e.id LIMIT 1)'))
                            ->where('ru.user_id', '=', $userId);
                    })
                    ->select(
                        'e.id',
                        'e.titulo',
                        'e.descripcion',
                        'e.fecha_inicio',
                        'e.fecha_fin',
                        'e.estado',
                        'e.dirigido_a',
                        'pl.nombre',
                        'pl.tipo'
                    )
                    ->where('e.id', $idencuesta)
                    ->whereNull('ru.id') // Verifica que no haya respuestas registradas para el usuario
                    ->get();

                if ($result->isEmpty()) {
                    // Si no hay resultados, redirige a otra ruta
                    return redirect()->route('home.student.index');
                }

                $preguntas = $this->listPreguntas($idencuesta);

                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('alumno.bienestar.encuestas.index')
                    ->with('datatipoacceso', $tipoacceso)
                    ->with('data', $result)
                    ->with('preguntas', $preguntas);
                } else if ($userTypeAccesocombo == "1") {
                    //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                    return redirect()->route('home.adm.dashboard')->withSuccess('Opps! You do not have access');
                } else if ($userTypeAccesocombo == "2") {
                    //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                    return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
                }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    public function listPreguntas($encuestaid)
    {

        // Obtener todas las preguntas de la encuesta con sus encuestaid
        $preguntas = DB::table('preguntas as pr')
            ->select('pr.id', 'pr.encuesta_id', 'pr.contenido as pregunta', 'pr.tipo')
            ->where('pr.encuesta_id', $encuestaid)
            ->get();

        if ($preguntas->isEmpty()) {
            return [];
        }

        // Procesar las preguntas y agregar opciones si es necesario
        $result = $preguntas->map(function ($pregunta) {
            if (in_array($pregunta->tipo, ['opcion_unica', 'multiple'])) {
                // Obtener opciones solo para preguntas de tipo 'unica' o 'multiple'
                $opciones = DB::table('opciones_respuesta as opr')
                    ->where('opr.pregunta_id', $pregunta->id)
                    ->select('id', 'contenido')
                    ->get();

                $pregunta->opciones = $opciones;
            } else {
                $pregunta->opciones = []; // Sin opciones para preguntas de texto
            }

            return $pregunta;
        });

        return $result;
    }



    public function store(Request $request)
    {
        // Recuperar todas las respuestas del formulario
        $respuestas = $request->except('_token'); // Excluir el token CSRF

        try {
            // Iterar a través de cada respuesta enviada
            foreach ($respuestas as $preguntaKey => $respuesta) {
                // Extraer el ID de la pregunta (pregunta_20 -> 20)
                $preguntaId = str_replace('pregunta_', '', $preguntaKey);

                if (is_array($respuesta)) {
                    // Si la respuesta es un array, es una pregunta de tipo "multiple"
                    foreach ($respuesta as $opcionId) {
                        // Usar el modelo Eloquent para insertar una respuesta
                        RespuestaUsuario::create([
                            'pregunta_id' => $preguntaId,
                            'respuesta_id' => $opcionId,
                            'respuesta_texto' => null,  // No hay texto
                            'user_id' => Auth::User()->id,  // No hay texto

                        ]);
                    }
                } else {
                    // Si la respuesta no es un array, puede ser de tipo "opcion_unica" o "texto"
                    if (is_numeric($respuesta)) {
                        // Si la respuesta es un número, es una opción única
                        RespuestaUsuario::create([
                            'pregunta_id' => $preguntaId,
                            'respuesta_id' => $respuesta,
                            'respuesta_texto' => null,  // No hay texto
                            'user_id' => Auth::User()->id,  // No hay texto
                        ]);
                    } else {
                        // Si no es un número, es una respuesta de tipo "texto"
                        RespuestaUsuario::create([
                            'pregunta_id' => $preguntaId,
                            'respuesta_id' => null,  // No hay opción seleccionada
                            'respuesta_texto' => $respuesta,
                            'user_id' => Auth::User()->id,  // No hay texto
                        ]);
                    }
                }
            }

            return response()->json(['status' => true, 'mensaje' => 'Respuestas guardadas exitosamente.']);
        } catch (\Exception $e) {
            return response()->json(['status' => false, 'mensaje' => 'Error al guardar las respuestas.', 'error' => $e->getMessage()]);
        }
    }
}
