<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Administrator;
use App\Models\Course;
use App\Models\Semesterperiod;
use App\Models\Subject;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Yajra\DataTables\Facades\DataTables;

class SemesterperiodController extends Controller
{
    //

    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.cursos.periodos_semestre.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }else if ($userTypeAccesocombo == "3"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    public function list(Request $request)
    {

        $idsemester = $request->input('idsemester');
        $idprogram = $request->input('idprogram');

        if ($request->ajax()) {
            // query
            $data = DB::table('semestres as se')
                ->crossJoin('periodos as pe')
                ->leftJoin('periodos_semestres as sp', function ($join) {
                    $join->on('se.id', '=', 'sp.semester_id')
                        ->on('pe.id', '=', 'sp.period_id');
                })
                ->join('planes as pl', 'pe.plan_id', '=', 'pl.id')
                ->join('programas as pr', 'pl.program_id', '=', 'pr.id')
                ->select(
                    'sp.id as idsemesterperiod',
                    'se.id as idsemester',
                    'se.anho as anhosemester',
                    'se.numero as numerosemester',
                    'se.fecinicio',
                    'se.fecfin',
                    'pr.id as idprogram',
                    'pr.codprograma',
                    'pr.nombre as nombreprogram',
                    'pr.nivel_formativo',
                    'pl.id as idplan',
                    'pl.nombre as nombreplan',
                    'pl.tipo',
                    'pl.modalidad',
                    'pl.enfoque',
                    'pe.id as idperiod',
                    'pe.numero as numeroperiod',
                    DB::raw("CASE WHEN sp.semester_id IS NOT NULL THEN '1' ELSE '0' END as relacion_estado")
                )
                ->where('se.id', $idsemester)
                ->where('pr.id', $idprogram)
                ->orderBy('pl.nombre', 'desc')  // descendente por plan 2024, 2023
                ->orderBy('pe.numero', 'asc')  // ascendente por periodo I, II, III, IV, V, VI
                ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }



    public function store(Request $request)
    {
        // $validator = Validator::make($request->all(), [
        //     'text_nombre_name' => 'required',
        //     'text_descripcion_name' => 'required',
        // ]);

        // if ($validator->fails()) {
        //     return response()->json(["status" => false, "errors" => $validator->errors()]);
        // }

        $item = new Semesterperiod();
        $item->semester_id = $request->input('txt-idsemester');
        $item->period_id = $request->input('txt-idperiod');

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {

            /*----- INICIO - Crear SUBJECTS espejo de los COURSES -----*/

            // Obtener todos los id's de los COURSES que existen registrados en un PERIOD
            $courseIds = Course::where('period_id', $request->input('txt-idperiod'))->pluck('id');

            // Crear array para poner toda la info de los SUBJECTS que se crearan
            $subjectsData = [];

            // Recorrer todos los id's de los COURSES existentes y crear SUBJECTS
            foreach ($courseIds as $idcurso) {
                $subjectsData[] = [
                    'seccion' => 'A',
                    'turno' => 'M',
                    'tipo' => 'Regular',
                    'nota_minima' => '13',
                    'silabo' => '--',
                    'instrumentos_evaluacion' => '--',
                    'course_id' => $idcurso,
                    'semester_id' => $request->input('txt-idsemester'),
                ];

                // $courses = Course::find($idcurso);


                // $moodleUrl = 'https://eva.casma.silferacademic.com/webservice/rest/server.php'; // URL de la API de Moodle
                // $token = '7dfe67aa33edc19f83b3454eae7b77b7';  // Tu token de acceso a la API


                // // Datos de la categoría a crear
                // $courseData = [
                //     [
                //         'fullname' => $courses->nombre,
                //         'shortname' => $courses->corcurso,
                //         'categoryid' => 163, // ID de la categoría padre, 0 para raíz
                //         'format' => 'topics', // Formato del curso (puedes cambiarlo a 'weeks' si lo deseas)
                //         'visible' => 1 // El curso será visible
                //     ]
                // ];


                // // Parámetros para crear el curso
                // $params = [
                //     'wstoken' => $token,
                //     'wsfunction' => 'core_course_create_courses',
                //     'moodlewsrestformat' => 'json',
                //     'courses' => $courseData,
                // ];


                // // Realizar la solicitud a la API de Moodle
                // $response = Http::asForm()->post($moodleUrl, $params);
                // $result = $response->json();
            };

            // if (isset($result['exception'])) {
            //     return back()->withErrors(['error' => 'Error: ' . $result['message']]);
            // }


            // Insertar todos los SUBJECTS a la base de datos
            Subject::insert($subjectsData);

            /*----- FIN - Crear SUBJECTS espejo de los COURSES -----*/

            return response()->json(["status" => true, "mensaje" => 'Asignaturas del periodo academico registradas en el periodo lectivo correctamente']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no enlazado']);
        }
    }


    public function destroy($id)
    {
        // Busca el registro por su ID
        $item = Semesterperiod::find($id);

        $period_id = $item->period_id;
        $semester_id = $item->semester_id;

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {


            // Eliminar registros en la tabla 'subjects' relacionados con el período eliminado

            Subject::where('semester_id', '=', $semester_id)
                ->whereIn('course_id', function ($query) use ($period_id) {
                    $query->select('id')
                        ->from('cursos')
                        ->where('period_id', '=', $period_id);
                })
                ->delete();


            return response()->json(["status" => true, "mensaje" => 'Las asignaturas fueron eliminadas']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
