<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Semester;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class SemesterController extends Controller
{



    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.institucion.semestres.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }else if ($userTypeAccesocombo == "3"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {

            DB::statement("SET lc_time_names = 'es_ES'");

            //$data = Semester::select('*');

            $data = Semester::select([
                'id',
                'anho',
                'numero',
                'tipo',
                'fecinicio',
                'fecfin',
                DB::raw('DATE_FORMAT(fecinicio, "%d - %M") as fecinicio2'),
                DB::raw('DATE_FORMAT(fecfin, "%d - %M") as fecfin2'),
                'estado',
                'estado_matricula',
            ])->orderBy('id', 'desc')->get();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function store(Request $request)
    {

        $item = new Semester();
        $item->anho = $request->input('txt_anho_name');
        $item->numero = $request->input('txt_numero_name');
        $item->tipo = $request->input('txt-tipo');
        $item->fecinicio = $request->input('txt_fecinicio_name');
        $item->fecfin = $request->input('txt_fecfin_name');
        $item->estado = 0;
        $item->estado_matricula = 0;

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            // El guardado fue exitoso
            return response()->json([
                "status" => true,
                "mensaje" => 'Éxito: registros realizado'
            ]);
        } else {
            // El guardado falló
            return response()->json([
                "status" => false,
                "mensaje" => 'Error: registros no realizado'
            ]);
        }
    }


    public function update(Request $request, $id)
    {

        $item = Semester::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->anho = $request->input('txt_anho_name');
            $item->numero = $request->input('txt_numero_name');
            $item->tipo = $request->input('txt-tipo');
            $item->fecinicio = $request->input('txt_fecinicio_name');
            $item->fecfin = $request->input('txt_fecfin_name');

            if ($item->save()) {
                // El guardado fue exitoso
                return response()->json([
                    "status" => true,
                    "mensaje" => 'Éxito: registros actualizado'
                ]);
            } else {
                // El guardado falló
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Error: registros no pudo ser actualizado'
                ]);
            }
        }
    }


    public function destroy($id)
    {
        // Busca el registro por su ID
        $Semester = Semester::find($id);

        // Verifica si el registro existe
        if (!$Semester) {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, el registro no existe'
            ]);
        }

        // Elimina el registro de la base de datos
        if ($Semester->delete()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'Éxito, el registro fue eliminado'
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, al eliminar registro'
            ]);
        }
    }


    public function update_estado(Request $request, $id)
    {
        $item = Semester::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $fechaFinSemestre = Carbon::parse($item->fecfin);
            $fechaActual = Carbon::now();

            if ($fechaActual->lte($fechaFinSemestre)) {
                // La fecha actual es menor o igual a la fecha de fin del semestre

                $item->estado = $request->input('txt-estado');

                if ($item->save()) {
                    // El guardado fue exitoso
                    return response()->json([
                        "status" => true,
                        "mensaje" => 'Estado de Notas actualizado'
                    ]);
                } else {
                    // El guardado falló
                    return response()->json([
                        "status" => false,
                        "mensaje" => 'No se pudo actualizar'
                    ]);
                }
            } else {
                // La fecha actual es mayor que la fecha de fin del semestre
                return response()->json([
                    "status" => false,
                    "mensaje" => 'No se puede actualizar el estado porque el semestre ya ha finalizado'
                ]);
            }
        }
    }


    public function update_estado_matricula(Request $request, $id)
    {
        $item = Semester::find($id);
        
        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $fechaFinSemestre = Carbon::parse($item->fecfin);
            $fechaActual = Carbon::now();
            
            if ($fechaActual->lte($fechaFinSemestre)) {
                // La fecha actual es menor o igual a la fecha de fin del semestre
                
                $item->estado_matricula = $request->input('txt-estado');
                
                if ($item->save()) {
                    // El guardado fue exitoso
                    return response()->json([
                        "status" => true,
                        "mensaje" => 'Estado de Notas actualizado'
                    ]);
                } else {
                    // El guardado falló
                    return response()->json([
                        "status" => false,
                        "mensaje" => 'No se pudo actualizar'
                    ]);
                }
            } else {
                // La fecha actual es mayor que la fecha de fin del semestre
                return response()->json([
                    "status" => false,
                    "mensaje" => 'No se puede actualizar el estado porque el semestre ya ha finalizado'
                ]);
            }
        }
    }


    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {

            DB::statement("SET lc_time_names = 'es_ES'");

            $data = Semester::select([
                'id',
                'anho',
                'numero',
                DB::raw('CONCAT(anho, "-", numero) as semestre'),
                DB::raw('DATE_FORMAT(fecinicio, "%d/%M") as fecinicio'),
                DB::raw('DATE_FORMAT(fecfin, "%d/%M") as fecfin'),
            ])
            ->orderBy('id', 'desc')
            ->get();

            setlocale(LC_TIME, null);

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }
}
